/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.net.LoginAuthenticator;
import ch.qos.logback.core.util.ContentTypeUtil;
import ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SMTPAppenderBase<E>
extends AppenderBase<E> {
    protected Layout<E> subjectLayout;
    protected Layout<E> layout;
    private List<String> to = new ArrayList<String>();
    private String from;
    private String subjectStr = null;
    private String smtpHost;
    private int smtpPort = 25;
    private boolean starttls = false;
    private boolean ssl = false;
    String username;
    String password;
    private String charsetEncoding = "UTF-8";
    protected MimeMessage mimeMsg;
    protected EventEvaluator<E> eventEvaluator;
    private int errorCount = 0;

    protected abstract Layout<E> makeSubjectLayout(String var1);

    @Override
    public void start() {
        Properties props = new Properties(OptionHelper.getSystemProperties());
        if (this.smtpHost != null) {
            props.put("mail.smtp.host", this.smtpHost);
        }
        props.put("mail.smtp.port", Integer.toString(this.smtpPort));
        LoginAuthenticator loginAuthenticator = null;
        if (this.username != null) {
            loginAuthenticator = new LoginAuthenticator(this.username, this.password);
            props.put("mail.smtp.auth", "true");
        }
        if (this.isSTARTTLS() && this.isSSL()) {
            this.addError("Both SSL and StartTLS cannot be enabled simultaneously");
        } else {
            if (this.isSTARTTLS()) {
                props.setProperty("mail.smtp.auth", "true");
                props.put("mail.smtp.starttls.enable", "true");
            }
            if (this.isSSL()) {
                String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
                props.put("mail.smtp.socketFactory.port", Integer.toString(this.smtpPort));
                props.put("mail.smtp.socketFactory.class", SSL_FACTORY);
                props.put("mail.smtp.socketFactory.fallback", "true");
            }
        }
        Session session = Session.getInstance((Properties)props, (Authenticator)loginAuthenticator);
        this.mimeMsg = new MimeMessage(session);
        try {
            if (this.from != null) {
                this.mimeMsg.setFrom((Address)this.getAddress(this.from));
            } else {
                this.mimeMsg.setFrom();
            }
            this.mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])this.parseAddress(this.to));
            this.subjectLayout = this.makeSubjectLayout(this.subjectStr);
            this.started = true;
        }
        catch (MessagingException e) {
            this.addError("Could not activate SMTPAppender options.", e);
        }
    }

    @Override
    protected void append(E eventObject) {
        block4: {
            if (!this.checkEntryConditions()) {
                return;
            }
            this.subAppend(eventObject);
            try {
                if (this.eventEvaluator.evaluate(eventObject)) {
                    this.sendBuffer(eventObject);
                }
            }
            catch (EvaluationException ex) {
                ++this.errorCount;
                if (this.errorCount >= 4) break block4;
                this.addError("SMTPAppender's EventEvaluator threw an Exception-", ex);
            }
        }
    }

    protected abstract void subAppend(E var1);

    public boolean checkEntryConditions() {
        if (!this.started) {
            this.addError("Attempting to append to a non-started appender: " + this.getName());
            return false;
        }
        if (this.mimeMsg == null) {
            this.addError("Message object not configured.");
            return false;
        }
        if (this.eventEvaluator == null) {
            this.addError("No EventEvaluator is set for appender [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.addError("No layout set for appender named [" + this.name + "]. For more information, please visit http://logback.qos.ch/codes.html#smtp_no_layout");
            return false;
        }
        return true;
    }

    @Override
    public synchronized void stop() {
        this.started = false;
    }

    InternetAddress getAddress(String addressStr) {
        try {
            return new InternetAddress(addressStr);
        }
        catch (AddressException e) {
            this.addError("Could not parse address [" + addressStr + "].", e);
            return null;
        }
    }

    InternetAddress[] parseAddress(List<String> addressList) {
        InternetAddress[] iaArray = new InternetAddress[addressList.size()];
        for (int i = 0; i < addressList.size(); ++i) {
            try {
                InternetAddress[] tmp = InternetAddress.parse((String)addressList.get(i), (boolean)true);
                iaArray[i] = tmp[0];
                continue;
            }
            catch (AddressException e) {
                this.addError("Could not parse address [" + addressList.get(i) + "].", e);
                return null;
            }
        }
        return iaArray;
    }

    public List<String> getTo() {
        return this.to;
    }

    protected void sendBuffer(E lastEventObject) {
        try {
            String contentType;
            String footer;
            String presentationHeader;
            MimeBodyPart part = new MimeBodyPart();
            StringBuffer sbuf = new StringBuffer();
            String header = this.layout.getFileHeader();
            if (header != null) {
                sbuf.append(header);
            }
            if ((presentationHeader = this.layout.getPresentationHeader()) != null) {
                sbuf.append(presentationHeader);
            }
            this.fillBuffer(sbuf);
            String presentationFooter = this.layout.getPresentationFooter();
            if (presentationFooter != null) {
                sbuf.append(presentationFooter);
            }
            if ((footer = this.layout.getFileFooter()) != null) {
                sbuf.append(footer);
            }
            if (this.subjectLayout != null) {
                this.mimeMsg.setSubject(this.subjectLayout.doLayout(lastEventObject), this.charsetEncoding);
            }
            if (ContentTypeUtil.isTextual(contentType = this.layout.getContentType())) {
                part.setText(sbuf.toString(), this.charsetEncoding, ContentTypeUtil.getSubType(contentType));
            } else {
                part.setContent((Object)sbuf.toString(), this.layout.getContentType());
            }
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)part);
            this.mimeMsg.setContent((Multipart)mp);
            this.mimeMsg.setSentDate(new Date());
            Transport.send((Message)this.mimeMsg);
        }
        catch (Exception e) {
            this.addError("Error occured while sending e-mail notification.", e);
        }
    }

    protected abstract void fillBuffer(StringBuffer var1);

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subjectStr;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setSubject(String subject) {
        this.subjectStr = subject;
    }

    public void setSMTPHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public String getSMTPHost() {
        return this.smtpHost;
    }

    public void setSMTPPort(int port) {
        this.smtpPort = port;
    }

    public int getSMTPPort() {
        return this.smtpPort;
    }

    public void addTo(String to) {
        this.to.add(to);
    }

    public Message getMessage() {
        return this.mimeMsg;
    }

    public void setMessage(MimeMessage msg) {
        this.mimeMsg = msg;
    }

    public boolean isSTARTTLS() {
        return this.starttls;
    }

    public void setSTARTTLS(boolean startTLS) {
        this.starttls = startTLS;
    }

    public boolean isSSL() {
        return this.ssl;
    }

    public void setSSL(boolean ssl) {
        this.ssl = ssl;
    }

    public void setEvaluator(EventEvaluator<E> eventEvaluator) {
        this.eventEvaluator = eventEvaluator;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCharsetEncoding() {
        return this.charsetEncoding;
    }

    public void setCharsetEncoding(String charsetEncoding) {
        this.charsetEncoding = charsetEncoding;
    }

    public Layout<E> getLayout() {
        return this.layout;
    }

    public void setLayout(Layout<E> layout) {
        this.layout = layout;
    }
}

