/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EncoderBase;
import java.io.IOException;
import java.io.OutputStream;

public class DummyEncoder<E>
extends EncoderBase<E> {
    public static final String DUMMY = "dummy" + CoreConstants.LINE_SEPARATOR;
    String val = DUMMY;
    String fileHeader;
    String fileFooter;
    String encodingName;

    public String getEncodingName() {
        return this.encodingName;
    }

    public void setEncodingName(String encodingName) {
        this.encodingName = encodingName;
    }

    public DummyEncoder() {
    }

    public DummyEncoder(String val) {
        this.val = val;
    }

    public void doEncode(E event) throws IOException {
        this.writeOut(this.val);
    }

    private void appendIfNotNull(StringBuilder sb, String s) {
        if (s != null) {
            sb.append(s);
        }
    }

    void writeOut(String s) throws IOException {
        if (this.encodingName == null) {
            this.outputStream.write(s.getBytes());
        } else {
            this.outputStream.write(s.getBytes(this.encodingName));
        }
    }

    void writeHeader() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.appendIfNotNull(sb, this.fileHeader);
        if (sb.length() > 0) {
            sb.append(CoreConstants.LINE_SEPARATOR);
            this.writeOut(sb.toString());
        }
    }

    public void init(OutputStream os) throws IOException {
        super.init(os);
        this.writeHeader();
    }

    public void close() throws IOException {
        if (this.fileFooter == null) {
            return;
        }
        if (this.encodingName == null) {
            this.outputStream.write(this.fileFooter.getBytes());
        } else {
            this.outputStream.write(this.fileFooter.getBytes(this.encodingName));
        }
    }

    public String getFileHeader() {
        return this.fileHeader;
    }

    public void setFileHeader(String fileHeader) {
        this.fileHeader = fileHeader;
    }

    public String getFileFooter() {
        return this.fileFooter;
    }

    public void setFileFooter(String fileFooter) {
        this.fileFooter = fileFooter;
    }
}

