/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.conditional;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.joran.TrivialConfigurator;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.IncludeAction;
import ch.qos.logback.core.joran.action.NOPAction;
import ch.qos.logback.core.joran.action.ext.StackAction;
import ch.qos.logback.core.joran.conditional.ElseAction;
import ch.qos.logback.core.joran.conditional.IfAction;
import ch.qos.logback.core.joran.conditional.ThenAction;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Stack;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IfThenElseAndIncludeCompositionTest {
    Context context = new ContextBase();
    TrivialConfigurator tc;
    int diff = RandomUtil.getPositiveInt();
    static final String CONDITIONAL_DIR_PREFIX = "src/test/input/joran/conditional/";
    static final String THEN_FILE_TO_INCLUDE_KEY = "thenFileToInclude";
    static final String ELSE_FILE_TO_INCLUDE_KEY = "elseFileToInclude";
    static final String NESTED_INCLUDE_FILE = "src/test/input/joran/conditional/nestedInclude.xml";
    static final String THEN_FILE_TO_INCLUDE = "src/test/input/joran/conditional/includedA.xml";
    static final String ELSE_FILE_TO_INCLUDE = "src/test/input/joran/conditional/includedB.xml";
    StackAction stackAction = new StackAction();

    @Before
    public void setUp() throws Exception {
        HashMap<ElementSelector, Action> rulesMap = new HashMap<ElementSelector, Action>();
        rulesMap.put(new ElementSelector("x"), (Action)new NOPAction());
        rulesMap.put(new ElementSelector("x/stack"), this.stackAction);
        rulesMap.put(new ElementSelector("*/if"), (Action)new IfAction());
        rulesMap.put(new ElementSelector("*/if/then"), (Action)new ThenAction());
        rulesMap.put(new ElementSelector("*/if/then/*"), (Action)new NOPAction());
        rulesMap.put(new ElementSelector("*/if/else"), (Action)new ElseAction());
        rulesMap.put(new ElementSelector("*/if/else/*"), (Action)new NOPAction());
        rulesMap.put(new ElementSelector("x/include"), (Action)new IncludeAction());
        this.tc = new TrivialConfigurator(rulesMap);
        this.tc.setContext(this.context);
    }

    @After
    public void tearDown() throws Exception {
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)this.context);
        this.context = null;
    }

    @Test
    public void includeNestedWithinIf() throws JoranException {
        this.context.putProperty(THEN_FILE_TO_INCLUDE_KEY, THEN_FILE_TO_INCLUDE);
        this.context.putProperty(ELSE_FILE_TO_INCLUDE_KEY, ELSE_FILE_TO_INCLUDE);
        this.tc.doConfigure(NESTED_INCLUDE_FILE);
        this.verifyConfig(new String[]{"BEGIN", "e0", "IncludedB0", "e1", "END"});
    }

    void verifyConfig(String[] expected) {
        Stack<String> witness = new Stack<String>();
        witness.addAll(Arrays.asList(expected));
        Assert.assertEquals(witness, this.stackAction.getStack());
    }
}

