/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.net.AbstractSocketAppender;
import ch.qos.logback.core.net.AutoFlushingObjectWriter;
import ch.qos.logback.core.net.ObjectWriterFactory;
import ch.qos.logback.core.net.QueueFactory;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.net.mock.MockContext;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.ExecutorServiceUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class AbstractSocketAppenderTest {
    private static final int TIMEOUT = 1000;
    private ScheduledExecutorService executorService = (ScheduledExecutorService)Mockito.spy((Object)ExecutorServiceUtil.newScheduledExecutorService());
    private MockContext mockContext = new MockContext(this.executorService);
    private PreSerializationTransformer<String> preSerializationTransformer = (PreSerializationTransformer)Mockito.spy((Object)new StringPreSerializationTransformer());
    private Socket socket = (Socket)Mockito.mock(Socket.class);
    private SocketConnector socketConnector = (SocketConnector)Mockito.mock(SocketConnector.class);
    private AutoFlushingObjectWriter objectWriter = (AutoFlushingObjectWriter)Mockito.mock(AutoFlushingObjectWriter.class);
    private ObjectWriterFactory objectWriterFactory = (ObjectWriterFactory)Mockito.mock(ObjectWriterFactory.class);
    private LinkedBlockingDeque<String> deque = (LinkedBlockingDeque)Mockito.spy(new LinkedBlockingDeque(1));
    private QueueFactory queueFactory = (QueueFactory)Mockito.mock(QueueFactory.class);
    private InstrumentedSocketAppender appender = (InstrumentedSocketAppender)((Object)Mockito.spy((Object)((Object)new InstrumentedSocketAppender(this.preSerializationTransformer, this.queueFactory, this.objectWriterFactory, this.socketConnector))));

    @Before
    public void setupValidAppenderWithMockDependencies() throws Exception {
        ((ObjectWriterFactory)Mockito.doReturn((Object)this.objectWriter).when((Object)this.objectWriterFactory)).newAutoFlushingObjectWriter((OutputStream)Matchers.any(OutputStream.class));
        ((QueueFactory)Mockito.doReturn(this.deque).when((Object)this.queueFactory)).newLinkedBlockingDeque(Matchers.anyInt());
        this.appender.setContext((Context)this.mockContext);
        this.appender.setRemoteHost("localhost");
    }

    @After
    public void tearDown() throws Exception {
        this.appender.stop();
        Assert.assertFalse((boolean)this.appender.isStarted());
        this.executorService.shutdownNow();
        Assert.assertTrue((boolean)this.executorService.awaitTermination(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void failsToStartWithoutValidPort() throws Exception {
        this.appender.setPort(-1);
        this.appender.start();
        Assert.assertFalse((boolean)this.appender.isStarted());
        ((InstrumentedSocketAppender)((Object)Mockito.verify((Object)((Object)this.appender)))).addError(Matchers.contains((String)"port"));
    }

    @Test
    public void failsToStartWithoutValidRemoteHost() throws Exception {
        this.appender.setRemoteHost(null);
        this.appender.start();
        Assert.assertFalse((boolean)this.appender.isStarted());
        ((InstrumentedSocketAppender)((Object)Mockito.verify((Object)((Object)this.appender)))).addError(Matchers.contains((String)"remote host"));
    }

    @Test
    public void failsToStartWithNegativeQueueSize() throws Exception {
        this.appender.setQueueSize(-1);
        this.appender.start();
        Assert.assertFalse((boolean)this.appender.isStarted());
        ((InstrumentedSocketAppender)((Object)Mockito.verify((Object)((Object)this.appender)))).addError(Matchers.contains((String)"Queue size must be greater than zero"));
    }

    @Test
    public void failsToStartWithUnresolvableRemoteHost() throws Exception {
        this.appender.setRemoteHost("NOT.A.VALID.REMOTE.HOST.NAME");
        this.appender.start();
        Assert.assertFalse((boolean)this.appender.isStarted());
        ((InstrumentedSocketAppender)((Object)Mockito.verify((Object)((Object)this.appender)))).addError(Matchers.contains((String)"unknown host"));
    }

    @Test
    public void startsButOutputsWarningWhenQueueSizeIsZero() throws Exception {
        this.appender.setQueueSize(0);
        this.appender.start();
        Assert.assertTrue((boolean)this.appender.isStarted());
        ((InstrumentedSocketAppender)((Object)Mockito.verify((Object)((Object)this.appender)))).addWarn("Queue size of zero is deprecated, use a size of one to indicate synchronous processing");
    }

    @Test
    public void startsWithValidParameters() throws Exception {
        this.appender.start();
        Assert.assertTrue((boolean)this.appender.isStarted());
    }

    @Test
    public void createsSocketConnectorWithConfiguredParameters() throws Exception {
        this.appender.setReconnectionDelay(new Duration(42L));
        this.appender.setRemoteHost("localhost");
        this.appender.setPort(21);
        this.appender.start();
        ((InstrumentedSocketAppender)((Object)Mockito.verify((Object)((Object)this.appender), (VerificationMode)Mockito.timeout((int)1000)))).newConnector(InetAddress.getByName("localhost"), 21, 0L, 42L);
    }

    @Test
    public void addsInfoMessageWhenSocketConnectionWasEstablished() throws Exception {
        this.mockOneSuccessfulSocketConnection();
        this.appender.start();
        ((InstrumentedSocketAppender)((Object)Mockito.verify((Object)((Object)this.appender), (VerificationMode)Mockito.timeout((int)1000)))).addInfo(Matchers.contains((String)"connection established"));
    }

    @Test
    public void addsInfoMessageWhenSocketConnectionFailed() throws Exception {
        this.mockOneSuccessfulSocketConnection();
        ((ObjectWriterFactory)Mockito.doThrow((Throwable)new IOException()).when((Object)this.objectWriterFactory)).newAutoFlushingObjectWriter((OutputStream)Matchers.any(OutputStream.class));
        this.appender.start();
        this.appender.append("some event");
        ((InstrumentedSocketAppender)((Object)Mockito.verify((Object)((Object)this.appender), (VerificationMode)Mockito.timeout((int)1000).atLeastOnce()))).addInfo(Matchers.contains((String)"connection failed"));
    }

    @Test
    public void closesSocketOnException() throws Exception {
        this.mockOneSuccessfulSocketConnection();
        ((ObjectWriterFactory)Mockito.doThrow((Throwable)new IOException()).when((Object)this.objectWriterFactory)).newAutoFlushingObjectWriter((OutputStream)Matchers.any(OutputStream.class));
        this.appender.start();
        this.appender.append("some event");
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.timeout((int)1000).atLeastOnce())).close();
    }

    @Test
    public void addsInfoMessageWhenSocketConnectionClosed() throws Exception {
        this.mockOneSuccessfulSocketConnection();
        ((ObjectWriterFactory)Mockito.doThrow((Throwable)new IOException()).when((Object)this.objectWriterFactory)).newAutoFlushingObjectWriter((OutputStream)Matchers.any(OutputStream.class));
        this.appender.start();
        this.appender.append("some event");
        ((InstrumentedSocketAppender)((Object)Mockito.verify((Object)((Object)this.appender), (VerificationMode)Mockito.timeout((int)1000).atLeastOnce()))).addInfo(Matchers.contains((String)"connection closed"));
    }

    @Test
    public void shutsDownOnInterruptWhileWaitingForEvent() throws Exception {
        this.mockOneSuccessfulSocketConnection();
        ((LinkedBlockingDeque)Mockito.doThrow((Throwable)new InterruptedException()).when(this.deque)).takeFirst();
        this.appender.start();
        ((LinkedBlockingDeque)Mockito.verify(this.deque, (VerificationMode)Mockito.timeout((int)1000))).takeFirst();
    }

    @Test
    public void shutsDownOnInterruptWhileWaitingForSocketConnection() throws Exception {
        ((SocketConnector)Mockito.doThrow((Throwable)new InterruptedException()).when((Object)this.socketConnector)).call();
        this.appender.start();
        ((SocketConnector)Mockito.verify((Object)this.socketConnector, (VerificationMode)Mockito.timeout((int)1000))).call();
    }

    @Test
    public void addsInfoMessageWhenShuttingDownDueToInterrupt() throws Exception {
        ((SocketConnector)Mockito.doThrow((Throwable)new InterruptedException()).when((Object)this.socketConnector)).call();
        this.appender.start();
        ((InstrumentedSocketAppender)((Object)Mockito.verify((Object)((Object)this.appender), (VerificationMode)Mockito.timeout((int)1000)))).addInfo(Matchers.contains((String)"shutting down"));
    }

    @Test
    public void offersEventsToTheEndOfTheDeque() throws Exception {
        this.appender.start();
        this.appender.append("some event");
        ((LinkedBlockingDeque)Mockito.verify(this.deque)).offer(Matchers.eq((Object)"some event"), Matchers.anyLong(), (TimeUnit)((Object)Matchers.any(TimeUnit.class)));
    }

    @Test
    public void doesNotQueueAnyEventsWhenStopped() throws Exception {
        this.appender.start();
        this.appender.stop();
        this.appender.append("some event");
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.deque});
    }

    @Test
    public void addsInfoMessageWhenEventCouldNotBeQueuedInConfiguredTimeoutDueToQueueSizeLimitation() throws Exception {
        long eventDelayLimit = 42L;
        ((LinkedBlockingDeque)Mockito.doReturn((Object)false).when(this.deque)).offer("some event", eventDelayLimit, TimeUnit.MILLISECONDS);
        this.appender.setEventDelayLimit(new Duration(eventDelayLimit));
        this.appender.start();
        this.appender.append("some event");
        ((InstrumentedSocketAppender)((Object)Mockito.verify((Object)((Object)this.appender)))).addInfo("Dropping event due to timeout limit of [" + eventDelayLimit + " milliseconds] being exceeded");
    }

    @Test
    public void takesEventsFromTheFrontOfTheDeque() throws Exception {
        this.mockOneSuccessfulSocketConnection();
        this.appender.start();
        this.awaitStartOfEventDispatching();
        this.appender.append("some event");
        ((LinkedBlockingDeque)Mockito.verify(this.deque, (VerificationMode)Mockito.timeout((int)1000).atLeastOnce())).takeFirst();
    }

    @Test
    public void reAddsEventAtTheFrontOfTheDequeWhenTransmissionFails() throws Exception {
        this.mockOneSuccessfulSocketConnection();
        ((AutoFlushingObjectWriter)Mockito.doThrow((Throwable)new IOException()).when((Object)this.objectWriter)).write(Matchers.anyObject());
        this.appender.start();
        this.awaitStartOfEventDispatching();
        this.appender.append("some event");
        ((LinkedBlockingDeque)Mockito.verify(this.deque, (VerificationMode)Mockito.timeout((int)1000).atLeastOnce())).offerFirst("some event");
    }

    @Test
    public void addsErrorMessageWhenAppendingIsInterruptedWhileWaitingForTheQueueToAcceptTheEvent() throws Exception {
        InterruptedException interruptedException = new InterruptedException();
        ((LinkedBlockingDeque)Mockito.doThrow((Throwable)interruptedException).when(this.deque)).offer(Matchers.eq((Object)"some event"), Matchers.anyLong(), (TimeUnit)((Object)Matchers.any(TimeUnit.class)));
        this.appender.start();
        this.appender.append("some event");
        ((InstrumentedSocketAppender)((Object)Mockito.verify((Object)((Object)this.appender)))).addError("Interrupted while appending event to SocketAppender", interruptedException);
    }

    @Test
    public void postProcessesEventsBeforeTransformingItToASerializable() throws Exception {
        this.mockOneSuccessfulSocketConnection();
        this.appender.start();
        this.awaitStartOfEventDispatching();
        this.appender.append("some event");
        this.awaitAtLeastOneEventToBeDispatched();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.appender, this.preSerializationTransformer});
        ((InstrumentedSocketAppender)((Object)inOrder.verify((Object)this.appender))).postProcessEvent("some event");
        ((PreSerializationTransformer)inOrder.verify(this.preSerializationTransformer)).transform((Object)"some event");
    }

    @Test
    public void writesSerializedEventToStream() throws Exception {
        this.mockOneSuccessfulSocketConnection();
        Mockito.when((Object)this.preSerializationTransformer.transform((Object)"some event")).thenReturn((Object)"some serialized event");
        this.appender.start();
        this.awaitStartOfEventDispatching();
        this.appender.append("some event");
        ((AutoFlushingObjectWriter)Mockito.verify((Object)this.objectWriter, (VerificationMode)Mockito.timeout((int)1000))).write((Object)"some serialized event");
    }

    @Test
    public void addsInfoMessageWhenEventIsBeingDroppedBecauseOfConnectionProblemAndDequeCapacityLimitReached() throws Exception {
        this.mockOneSuccessfulSocketConnection();
        ((AutoFlushingObjectWriter)Mockito.doThrow((Throwable)new IOException()).when((Object)this.objectWriter)).write(Matchers.anyObject());
        ((LinkedBlockingDeque)Mockito.doReturn((Object)false).when(this.deque)).offerFirst("some event");
        this.appender.start();
        this.awaitStartOfEventDispatching();
        Mockito.reset((Object[])new InstrumentedSocketAppender[]{this.appender});
        this.appender.append("some event");
        ((InstrumentedSocketAppender)((Object)Mockito.verify((Object)((Object)this.appender), (VerificationMode)Mockito.timeout((int)1000)))).addInfo("Dropping event due to socket connection error and maxed out deque capacity");
    }

    @Test
    public void reEstablishesSocketConnectionOnConnectionDropWhenWritingEvent() throws Exception {
        this.mockTwoSuccessfulSocketConnections();
        ((AutoFlushingObjectWriter)Mockito.doThrow((Throwable)new IOException()).when((Object)this.objectWriter)).write(Matchers.anyObject());
        this.appender.start();
        this.awaitStartOfEventDispatching();
        this.appender.append("some event");
        ((ObjectWriterFactory)Mockito.verify((Object)this.objectWriterFactory, (VerificationMode)Mockito.timeout((int)1000).atLeast(2))).newAutoFlushingObjectWriter((OutputStream)Matchers.any(OutputStream.class));
    }

    @Test
    public void triesToReEstablishSocketConnectionIfItFailed() throws Exception {
        this.mockOneSuccessfulSocketConnection();
        ((Socket)Mockito.doThrow((Throwable)new IOException()).when((Object)this.socket)).getOutputStream();
        this.appender.start();
        this.appender.append("some event");
        ((SocketConnector)Mockito.verify((Object)this.socketConnector, (VerificationMode)Mockito.timeout((int)1000).atLeast(2))).call();
    }

    @Test
    public void usesConfiguredAcceptConnectionTimeoutAndResetsSocketTimeoutAfterSuccessfulConnection() throws Exception {
        this.mockOneSuccessfulSocketConnection();
        this.appender.setAcceptConnectionTimeout(42);
        this.appender.start();
        this.awaitStartOfEventDispatching();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.socket});
        ((Socket)inOrder.verify((Object)this.socket)).setSoTimeout(42);
        ((Socket)inOrder.verify((Object)this.socket)).setSoTimeout(0);
    }

    private void awaitAtLeastOneEventToBeDispatched() throws IOException {
        ((AutoFlushingObjectWriter)Mockito.verify((Object)this.objectWriter, (VerificationMode)Mockito.timeout((int)1000))).write((Object)Matchers.anyString());
    }

    private void awaitStartOfEventDispatching() throws InterruptedException {
        ((LinkedBlockingDeque)Mockito.verify(this.deque, (VerificationMode)Mockito.timeout((int)1000))).takeFirst();
    }

    private void mockOneSuccessfulSocketConnection() throws InterruptedException {
        ((SocketConnector)Mockito.doReturn((Object)this.socket).doReturn(null).when((Object)this.socketConnector)).call();
    }

    private void mockTwoSuccessfulSocketConnections() throws InterruptedException {
        ((SocketConnector)Mockito.doReturn((Object)this.socket).doReturn((Object)this.socket).doReturn(null).when((Object)this.socketConnector)).call();
    }

    private static class StringPreSerializationTransformer
    implements PreSerializationTransformer<String> {
        private StringPreSerializationTransformer() {
        }

        public Serializable transform(String event) {
            return event;
        }
    }

    private static class InstrumentedSocketAppender
    extends AbstractSocketAppender<String> {
        private PreSerializationTransformer<String> preSerializationTransformer;
        private SocketConnector socketConnector;

        public InstrumentedSocketAppender(PreSerializationTransformer<String> preSerializationTransformer, QueueFactory queueFactory, ObjectWriterFactory objectWriterFactory, SocketConnector socketConnector) {
            super(queueFactory, objectWriterFactory);
            this.preSerializationTransformer = preSerializationTransformer;
            this.socketConnector = socketConnector;
        }

        protected void postProcessEvent(String event) {
        }

        protected PreSerializationTransformer<String> getPST() {
            return this.preSerializationTransformer;
        }

        protected SocketConnector newConnector(InetAddress address, int port, long initialDelay, long retryDelay) {
            return this.socketConnector;
        }
    }
}

