/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.sanity;

import ch.qos.logback.core.joran.sanity.Pair;
import ch.qos.logback.core.joran.sanity.SanityChecker;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.util.ArrayList;
import java.util.List;

public class AppenderWithinAppenderSanityChecker
extends ContextAwareBase
implements SanityChecker {
    public static String NESTED_APPENDERS_WARNING = "As of logback version 1.3, nested appenders are not allowed.";

    @Override
    public void check(Model model) {
        if (model == null) {
            return;
        }
        ArrayList<Model> appenderModels = new ArrayList<Model>();
        this.deepFindAllModelsOfType(AppenderModel.class, appenderModels, model);
        List<Pair<Model, Model>> nestedPairs = this.deepFindNestedSubModelsOfType(AppenderModel.class, appenderModels);
        if (nestedPairs.isEmpty()) {
            return;
        }
        this.addWarn(NESTED_APPENDERS_WARNING);
        for (Pair<Model, Model> pair : nestedPairs) {
            this.addWarn("Appender at line " + ((Model)pair.first).getLineNumber() + " contains a nested appender at line " + ((Model)pair.second).getLineNumber());
        }
    }
}

