/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor;

import cn.hippo4j.common.toolkit.CalculateUtil;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.manage.GlobalNotifyAlarmManage;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.support.ThreadPoolBuilder;
import cn.hippo4j.core.toolkit.IdentifyUtil;
import cn.hippo4j.core.toolkit.TraceContextUtil;
import cn.hippo4j.message.enums.NotifyTypeEnum;
import cn.hippo4j.message.request.AlarmNotifyRequest;
import cn.hippo4j.message.request.ChangeParameterNotifyRequest;
import cn.hippo4j.message.service.Hippo4jSendMessageService;
import cn.hippo4j.message.service.ThreadPoolNotifyAlarm;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;

public class ThreadPoolNotifyAlarmHandler
implements Runnable,
CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolNotifyAlarmHandler.class);
    @NonNull
    private final Hippo4jSendMessageService hippo4jSendMessageService;
    @Value(value="${spring.profiles.active:UNKNOWN}")
    private String active;
    @Value(value="${spring.dynamic.thread-pool.item-id:}")
    private String itemId;
    @Value(value="${spring.application.name:UNKNOWN}")
    private String applicationName;
    @Value(value="${spring.dynamic.thread-pool.check-state-interval:5}")
    private Integer checkStateInterval;
    private final ScheduledExecutorService ALARM_NOTIFY_EXECUTOR = new ScheduledThreadPoolExecutor(1, r -> new Thread(r, "client.alarm.notify"));
    private final ExecutorService ASYNC_ALARM_NOTIFY_EXECUTOR = ThreadPoolBuilder.builder().poolThreadSize(2, 4).threadFactory("client.execute.timeout.alarm").allowCoreThreadTimeOut(true).keepAliveTime(60L, TimeUnit.SECONDS).workQueue(new LinkedBlockingQueue(4096)).rejected(new ThreadPoolExecutor.AbortPolicy()).build();

    public void run(String ... args) throws Exception {
        this.ALARM_NOTIFY_EXECUTOR.scheduleWithFixedDelay(this, 0L, this.checkStateInterval.intValue(), TimeUnit.SECONDS);
    }

    @Override
    public void run() {
        List<String> listThreadPoolId = GlobalThreadPoolManage.listThreadPoolId();
        listThreadPoolId.forEach(threadPoolId -> {
            ThreadPoolNotifyAlarm threadPoolNotifyAlarm = GlobalNotifyAlarmManage.get(threadPoolId);
            if (threadPoolNotifyAlarm != null && threadPoolNotifyAlarm.getAlarm().booleanValue()) {
                DynamicThreadPoolWrapper wrapper = GlobalThreadPoolManage.getExecutorService(threadPoolId);
                ThreadPoolExecutor executor = wrapper.getExecutor();
                this.checkPoolCapacityAlarm((String)threadPoolId, executor);
                this.checkPoolActivityAlarm((String)threadPoolId, executor);
            }
        });
    }

    public void checkPoolCapacityAlarm(String threadPoolId, ThreadPoolExecutor threadPoolExecutor) {
        boolean isSend;
        ThreadPoolNotifyAlarm alarmConfig = GlobalNotifyAlarmManage.get(threadPoolId);
        if (Objects.isNull(alarmConfig) || !alarmConfig.getAlarm().booleanValue() || alarmConfig.getCapacityAlarm() <= 0) {
            return;
        }
        BlockingQueue<Runnable> blockingQueue = threadPoolExecutor.getQueue();
        int queueSize = blockingQueue.size();
        int capacity = queueSize + blockingQueue.remainingCapacity();
        int divide = CalculateUtil.divide((int)queueSize, (int)capacity);
        boolean bl = isSend = alarmConfig.getAlarm() != false && divide > alarmConfig.getCapacityAlarm();
        if (isSend) {
            AlarmNotifyRequest alarmNotifyRequest = this.buildAlarmNotifyRequest(threadPoolExecutor);
            alarmNotifyRequest.setThreadPoolId(threadPoolId);
            this.hippo4jSendMessageService.sendAlarmMessage(NotifyTypeEnum.CAPACITY, alarmNotifyRequest);
        }
    }

    public void checkPoolActivityAlarm(String threadPoolId, ThreadPoolExecutor threadPoolExecutor) {
        boolean isSend;
        ThreadPoolNotifyAlarm alarmConfig = GlobalNotifyAlarmManage.get(threadPoolId);
        if (Objects.isNull(alarmConfig) || !alarmConfig.getAlarm().booleanValue() || alarmConfig.getCapacityAlarm() <= 0) {
            return;
        }
        int activeCount = threadPoolExecutor.getActiveCount();
        int maximumPoolSize = threadPoolExecutor.getMaximumPoolSize();
        int divide = CalculateUtil.divide((int)activeCount, (int)maximumPoolSize);
        boolean bl = isSend = alarmConfig.getAlarm() != false && divide > alarmConfig.getActiveAlarm();
        if (isSend) {
            AlarmNotifyRequest alarmNotifyRequest = this.buildAlarmNotifyRequest(threadPoolExecutor);
            alarmNotifyRequest.setThreadPoolId(threadPoolId);
            this.hippo4jSendMessageService.sendAlarmMessage(NotifyTypeEnum.ACTIVITY, alarmNotifyRequest);
        }
    }

    public void asyncSendRejectedAlarm(String threadPoolId) {
        Runnable checkPoolRejectedAlarmTask = () -> {
            ThreadPoolNotifyAlarm alarmConfig = GlobalNotifyAlarmManage.get(threadPoolId);
            if (Objects.isNull(alarmConfig) || !alarmConfig.getAlarm().booleanValue()) {
                return;
            }
            ThreadPoolExecutor threadPoolExecutor = GlobalThreadPoolManage.getExecutorService(threadPoolId).getExecutor();
            if (threadPoolExecutor instanceof DynamicThreadPoolExecutor) {
                AlarmNotifyRequest alarmNotifyRequest = this.buildAlarmNotifyRequest(threadPoolExecutor);
                alarmNotifyRequest.setThreadPoolId(threadPoolId);
                this.hippo4jSendMessageService.sendAlarmMessage(NotifyTypeEnum.REJECT, alarmNotifyRequest);
            }
        };
        this.ASYNC_ALARM_NOTIFY_EXECUTOR.execute(checkPoolRejectedAlarmTask);
    }

    public void asyncSendExecuteTimeOutAlarm(String threadPoolId, long executeTime, long executeTimeOut, ThreadPoolExecutor threadPoolExecutor) {
        ThreadPoolNotifyAlarm alarmConfig = GlobalNotifyAlarmManage.get(threadPoolId);
        if (Objects.isNull(alarmConfig) || !alarmConfig.getAlarm().booleanValue()) {
            return;
        }
        if (threadPoolExecutor instanceof DynamicThreadPoolExecutor) {
            try {
                AlarmNotifyRequest alarmNotifyRequest = this.buildAlarmNotifyRequest(threadPoolExecutor);
                alarmNotifyRequest.setThreadPoolId(threadPoolId);
                alarmNotifyRequest.setExecuteTime(Long.valueOf(executeTime));
                alarmNotifyRequest.setExecuteTimeOut(Long.valueOf(executeTimeOut));
                String executeTimeoutTrace = TraceContextUtil.getAndRemove();
                if (StringUtil.isNotBlank((CharSequence)executeTimeoutTrace)) {
                    alarmNotifyRequest.setExecuteTimeoutTrace(executeTimeoutTrace);
                }
                Runnable task = () -> this.hippo4jSendMessageService.sendAlarmMessage(NotifyTypeEnum.TIMEOUT, alarmNotifyRequest);
                this.ASYNC_ALARM_NOTIFY_EXECUTOR.execute(task);
            }
            catch (Throwable ex) {
                log.error("Send thread pool execution timeout alarm error.", ex);
            }
        }
    }

    public void sendPoolConfigChange(ChangeParameterNotifyRequest request) {
        request.setActive(this.active.toUpperCase());
        String appName = StringUtil.isBlank((CharSequence)this.itemId) ? this.applicationName : this.itemId;
        request.setAppName(appName);
        request.setIdentify(IdentifyUtil.getIdentify());
        this.hippo4jSendMessageService.sendChangeMessage(request);
    }

    public AlarmNotifyRequest buildAlarmNotifyRequest(ThreadPoolExecutor threadPoolExecutor) {
        BlockingQueue<Runnable> blockingQueue = threadPoolExecutor.getQueue();
        RejectedExecutionHandler rejectedExecutionHandler = threadPoolExecutor instanceof DynamicThreadPoolExecutor ? ((DynamicThreadPoolExecutor)threadPoolExecutor).getRedundancyHandler() : threadPoolExecutor.getRejectedExecutionHandler();
        long rejectCount = threadPoolExecutor instanceof DynamicThreadPoolExecutor ? ((DynamicThreadPoolExecutor)threadPoolExecutor).getRejectCountNum() : -1L;
        return AlarmNotifyRequest.builder().appName(StringUtil.isBlank((CharSequence)this.itemId) ? this.applicationName : this.itemId).active(this.active.toUpperCase()).identify(IdentifyUtil.getIdentify()).corePoolSize(Integer.valueOf(threadPoolExecutor.getCorePoolSize())).maximumPoolSize(Integer.valueOf(threadPoolExecutor.getMaximumPoolSize())).poolSize(Integer.valueOf(threadPoolExecutor.getPoolSize())).activeCount(Integer.valueOf(threadPoolExecutor.getActiveCount())).largestPoolSize(Integer.valueOf(threadPoolExecutor.getLargestPoolSize())).completedTaskCount(Long.valueOf(threadPoolExecutor.getCompletedTaskCount())).queueName(blockingQueue.getClass().getSimpleName()).capacity(Integer.valueOf(blockingQueue.size() + blockingQueue.remainingCapacity())).queueSize(Integer.valueOf(blockingQueue.size())).remainingCapacity(Integer.valueOf(blockingQueue.remainingCapacity())).rejectedExecutionHandlerName(rejectedExecutionHandler.getClass().getSimpleName()).rejectCountNum(Long.valueOf(rejectCount)).build();
    }

    public ThreadPoolNotifyAlarmHandler(@NonNull Hippo4jSendMessageService hippo4jSendMessageService) {
        if (hippo4jSendMessageService == null) {
            throw new NullPointerException("hippo4jSendMessageService is marked non-null but is null");
        }
        this.hippo4jSendMessageService = hippo4jSendMessageService;
    }
}

