/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor.manage;

import cn.hippo4j.common.config.ApplicationContextHolder;
import cn.hippo4j.common.model.ThreadPoolParameter;
import cn.hippo4j.common.model.register.DynamicThreadPoolRegisterWrapper;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.support.service.DynamicThreadPoolService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;

public class GlobalThreadPoolManage {
    private static final Map<String, ThreadPoolParameter> POOL_PARAMETER = new ConcurrentHashMap<String, ThreadPoolParameter>();
    private static final Map<String, DynamicThreadPoolWrapper> EXECUTOR_MAP = new ConcurrentHashMap<String, DynamicThreadPoolWrapper>();

    public static DynamicThreadPoolWrapper getExecutorService(String threadPoolId) {
        return EXECUTOR_MAP.get(threadPoolId);
    }

    public static ThreadPoolExecutor getExecutor(String threadPoolId) {
        return Optional.ofNullable(EXECUTOR_MAP.get(threadPoolId)).map(each -> each.getExecutor()).orElse(null);
    }

    public static ThreadPoolParameter getPoolParameter(String threadPoolId) {
        return POOL_PARAMETER.get(threadPoolId);
    }

    public static void register(String threadPoolId, ThreadPoolParameter threadPoolParameter, DynamicThreadPoolWrapper executor) {
        GlobalThreadPoolManage.registerPool(threadPoolId, executor);
        GlobalThreadPoolManage.registerPoolParameter(threadPoolId, threadPoolParameter);
    }

    public static void registerPool(String threadPoolId, DynamicThreadPoolWrapper executor) {
        EXECUTOR_MAP.put(threadPoolId, executor);
    }

    public static void registerPoolParameter(String threadPoolId, ThreadPoolParameter poolParameter) {
        POOL_PARAMETER.put(threadPoolId, poolParameter);
    }

    public static ThreadPoolExecutor dynamicRegister(DynamicThreadPoolRegisterWrapper registerWrapper) {
        DynamicThreadPoolService dynamicThreadPoolService = (DynamicThreadPoolService)ApplicationContextHolder.getBean(DynamicThreadPoolService.class);
        return dynamicThreadPoolService.registerDynamicThreadPool(registerWrapper);
    }

    public static List<String> listThreadPoolId() {
        return new ArrayList<String>(EXECUTOR_MAP.keySet());
    }

    public static Integer getThreadPoolNum() {
        return GlobalThreadPoolManage.listThreadPoolId().size();
    }
}

