/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.common.http;

import cn.jeeweb.common.http.Response;
import cn.jeeweb.common.query.data.Page;
import java.io.Serializable;
import java.util.List;

public class PageResponse<T>
extends Response
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long page = 1L;
    private long rows = 10L;
    private long total;
    private long totalPages;
    private List<T> results;

    public PageResponse() {
    }

    public PageResponse(List<T> results) {
        this(0L, Long.MAX_VALUE, Long.MAX_VALUE, results);
    }

    public PageResponse(Page<T> page) {
        this(page.getNumber(), page.getSize(), page.getTotalElements(), page.getContent());
    }

    public PageResponse(long page, long rows, long total, List<T> results) {
        this.page = page;
        this.rows = rows;
        this.total = total;
        this.results = results;
        this.totalPages = this.getRows() == 0L ? 1L : (long)((int)Math.ceil((double)total / (double)this.getRows()));
        this.put("page", this.page);
        this.put("rows", this.rows);
        this.put("total", this.total);
        this.put("results", this.results);
        this.put("totalPages", this.totalPages);
    }

    public long getPage() {
        return this.page;
    }

    public void setPage(long page) {
        this.page = page;
    }

    public long getRows() {
        return this.rows;
    }

    public void setRows(long rows) {
        this.rows = rows;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public long getTotalPages() {
        return this.totalPages;
    }

    public List<T> getResults() {
        return this.results;
    }

    public void setResults(List<T> results) {
        this.results = results;
    }
}

