/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.common.http;

import cn.jeeweb.common.utils.fastjson.FastjsonPropertyPreFilter;
import cn.jeeweb.common.utils.fastjson.FastjsonUnXssFilter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Response
extends HashMap<String, Object>
implements Serializable {
    private static final int OK_CODE = 0;
    private static final int ERROR_CODE = 500;

    public Response() {
        this.put("code", 0);
        this.put("msg", "\u64cd\u4f5c\u6210\u529f");
    }

    public Response putList(String key, List list, String includesProperties) {
        if (list.size() > 0) {
            FastjsonPropertyPreFilter fastjsonPropertyPreFilter = new FastjsonPropertyPreFilter(list.get(0).getClass().getClass(), includesProperties);
            FastjsonUnXssFilter fastjsonUnXssFilter = new FastjsonUnXssFilter();
            SerializeFilter[] filters = new SerializeFilter[]{fastjsonPropertyPreFilter, fastjsonUnXssFilter};
            String objectStr = JSON.toJSONString((Object)list, (SerializeFilter[])filters, (SerializerFeature[])new SerializerFeature[0]);
            List dataList = (List)JSON.parseObject((String)objectStr, List.class);
            this.put(key, dataList);
        } else {
            this.put(key, new ArrayList());
        }
        return this;
    }

    public Response putList(String key, List list) {
        if (list.size() > 0) {
            FastjsonUnXssFilter fastjsonUnXssFilter = new FastjsonUnXssFilter();
            SerializeFilter[] filters = new SerializeFilter[]{fastjsonUnXssFilter};
            String objectStr = JSON.toJSONString((Object)list, (SerializeFilter[])filters, (SerializerFeature[])new SerializerFeature[0]);
            List dataList = (List)JSON.parseObject((String)objectStr, List.class);
            this.put(key, dataList);
        } else {
            this.put(key, new ArrayList());
        }
        return this;
    }

    public Response putObject(Object object, String includesProperties) {
        if (object != null) {
            FastjsonPropertyPreFilter fastjsonPropertyPreFilter = new FastjsonPropertyPreFilter(object.getClass().getClass(), includesProperties);
            FastjsonUnXssFilter fastjsonUnXssFilter = new FastjsonUnXssFilter();
            SerializeFilter[] filters = new SerializeFilter[]{fastjsonPropertyPreFilter, fastjsonUnXssFilter};
            String objectStr = JSON.toJSONString((Object)object, (SerializeFilter[])filters, (SerializerFeature[])new SerializerFeature[0]);
            Map dataMap = (Map)JSON.parseObject((String)objectStr, Map.class);
            dataMap.remove("class");
            this.putAll(dataMap);
        }
        return this;
    }

    public Response putObject(Object object) {
        if (object != null) {
            FastjsonUnXssFilter fastjsonUnXssFilter = new FastjsonUnXssFilter();
            String objectStr = JSON.toJSONString((Object)object, (SerializeFilter)fastjsonUnXssFilter, (SerializerFeature[])new SerializerFeature[0]);
            Map dataMap = (Map)JSON.parseObject((String)objectStr, Map.class);
            dataMap.remove("class");
            this.putAll(dataMap);
        }
        return this;
    }

    public static Response ok() {
        return new Response();
    }

    public static Response ok(String msg) {
        return Response.error(0, msg);
    }

    public static Response error(String msg) {
        return Response.error(500, msg);
    }

    public static Response error(int code, String msg) {
        Response response = new Response();
        response.put("code", code);
        response.put("msg", msg);
        return response;
    }
}

