/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.common.mvc.controller;

import cn.jeeweb.common.mvc.controller.BaseController;
import cn.jeeweb.common.mvc.exception.ValidationException;
import cn.jeeweb.common.utils.MessageUtils;
import cn.jeeweb.common.utils.ReflectionUtils;
import cn.jeeweb.common.utils.StringUtils;
import java.io.Serializable;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;

public abstract class BaseBeanController<Entity extends Serializable>
extends BaseController {
    protected final Class<Entity> entityClass = ReflectionUtils.getSuperGenericType(this.getClass());

    protected BaseBeanController() {
    }

    protected Entity newModel() {
        try {
            return (Entity)((Serializable)this.entityClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalStateException("can not instantiated model : " + this.entityClass, e);
        }
    }

    protected boolean hasError(Entity entity, BindingResult result) {
        Assert.notNull(entity);
        return result.hasErrors();
    }

    protected void checkError(Entity entity, BindingResult result) {
        if (this.hasError(entity, result)) {
            String errorMsg = this.errorMsg(result);
            if (!StringUtils.isEmpty((String)errorMsg)) {
                throw new ValidationException(errorMsg);
            }
            throw new ValidationException("\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    protected String errorMsg(BindingResult result) {
        String errorMsg = "";
        if (result.getErrorCount() > 0) {
            List objectErrorList = result.getAllErrors();
            for (ObjectError objectError : objectErrorList) {
                String message = MessageUtils.getMessage((String)objectError.getCode(), (String)objectError.getDefaultMessage(), (Object[])objectError.getArguments());
                if (StringUtils.isEmpty((String)message)) continue;
                errorMsg = errorMsg + message + "<br />";
            }
        }
        return errorMsg;
    }

    protected String redirectToUrl(String backURL) {
        if (StringUtils.isEmpty((String)backURL)) {
            backURL = this.getViewPrefix();
        }
        if (!backURL.startsWith("/") && !backURL.startsWith("http")) {
            backURL = "/" + backURL;
        }
        return "redirect:" + backURL;
    }
}

