/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.common.mvc.controller;

import cn.jeeweb.common.mvc.annotation.ViewPrefix;
import cn.jeeweb.common.utils.StringUtils;
import cn.jeeweb.common.utils.convert.DateConvertEditor;
import cn.jeeweb.common.utils.convert.StringConvertEditor;
import com.alibaba.fastjson.JSON;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.servlet.ModelAndView;

public class BaseController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private String viewPrefix;

    protected BaseController() {
        this.setViewPrefix(this.defaultViewPrefix());
    }

    protected void printString(HttpServletResponse response, Object object) {
        this.printString(response, JSON.toJSONString((Object)object));
    }

    protected void printString(HttpServletResponse response, String string) {
        try {
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            response.getWriter().print(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @InitBinder
    void initBinder(ServletRequestDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringConvertEditor());
        binder.registerCustomEditor(Date.class, (PropertyEditor)new DateConvertEditor());
    }

    public void setViewPrefix(String viewPrefix) {
        if (viewPrefix.startsWith("/")) {
            viewPrefix = viewPrefix.substring(1);
        }
        this.viewPrefix = viewPrefix;
    }

    public String getViewPrefix() {
        return this.viewPrefix;
    }

    public String display(String suffixName) {
        if (!suffixName.startsWith("/")) {
            suffixName = "/" + suffixName;
        }
        return this.getViewPrefix().toLowerCase() + suffixName;
    }

    public ModelAndView displayModelAndView(String suffixName) {
        if (!suffixName.startsWith("/")) {
            suffixName = "/" + suffixName;
        }
        return new ModelAndView(this.getViewPrefix().toLowerCase() + suffixName);
    }

    protected String defaultViewPrefix() {
        String currentViewPrefix = "";
        ViewPrefix viewPrefix = (ViewPrefix)AnnotationUtils.findAnnotation(this.getClass(), ViewPrefix.class);
        if (viewPrefix != null && !StringUtils.isEmpty((String)viewPrefix.value())) {
            currentViewPrefix = viewPrefix.value();
        }
        if (StringUtils.isEmpty((String)currentViewPrefix)) {
            currentViewPrefix = this.getClass().getSimpleName().replace("Controller", "").toLowerCase();
        }
        return currentViewPrefix;
    }
}

