/*
 * Decompiled with CFR 0.152.
 */
package cn.jeeweb.common.mvc.entity.tree;

import cn.jeeweb.common.mvc.entity.tree.TreeNode;
import cn.jeeweb.common.utils.ObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TreeSortUtil<ID extends Serializable>
implements Serializable {
    private static final long serialVersionUID = 2444638065060902858L;
    private List<TreeNode<ID>> treeNodes;
    private List<TreeNode<ID>> newTreeNodes = new ArrayList<TreeNode<ID>>();

    public static <T extends Serializable> TreeSortUtil<T> create() {
        TreeSortUtil treeSortUtil = new TreeSortUtil();
        return treeSortUtil;
    }

    public List<TreeNode<ID>> getTopNodes() {
        ArrayList<TreeNode<ID>> list = new ArrayList<TreeNode<ID>>();
        for (TreeNode<ID> treeable : this.treeNodes) {
            if (!treeable.isRoot()) continue;
            list.add(treeable);
        }
        return list;
    }

    public void parseSubNode(TreeNode<ID> node) {
        for (TreeNode<ID> treeable : this.treeNodes) {
            if (ObjectUtils.isNullOrEmpty(treeable.getParentId()) || !((Serializable)treeable.getParentId()).equals(node.getId())) continue;
            this.newTreeNodes.add(treeable);
            this.parseSubNode(treeable);
        }
    }

    public TreeSortUtil<ID> sort(List<?> treeNodes) {
        this.treeNodes = treeNodes;
        List<TreeNode<ID>> rootNodes = this.getTopNodes();
        for (TreeNode<ID> rootNode : rootNodes) {
            this.newTreeNodes.add(rootNode);
            this.parseSubNode(rootNode);
        }
        this.treeNodes.clear();
        this.treeNodes.addAll(this.newTreeNodes);
        return this;
    }

    public TreeSortUtil<ID> async(List<?> treeNodes) {
        this.treeNodes = treeNodes;
        for (TreeNode<ID> treeNode : this.treeNodes) {
            treeNode.setLoaded(true);
        }
        return this;
    }

    public TreeSortUtil<ID> sync(List<?> treeNodes) {
        this.treeNodes = treeNodes;
        for (TreeNode<ID> treeNode : this.treeNodes) {
            treeNode.setLoaded(false);
        }
        return this;
    }
}

