/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.security.authentication.client;

import co.cask.cdap.security.authentication.client.AccessToken;
import co.cask.cdap.security.authentication.client.AuthenticationClient;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpRequestConfig;
import co.cask.common.http.HttpRequests;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import co.cask.common.http.exception.HttpFailureException;
import com.google.common.base.Throwables;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticationClient
implements AuthenticationClient {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAuthenticationClient.class);
    private static final Random RANDOM = new Random();
    private static final String AUTH_URI_KEY = "auth_uri";
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private static final String ACCESS_TOKEN_KEY = "access_token";
    private static final String EXPIRES_IN_KEY = "expires_in";
    private static final String TOKEN_TYPE_KEY = "token_type";
    private static final long SPARE_TIME_IN_MILLIS = 5000L;
    private static final TypeToken<Map<String, String>> ACCESS_TOKEN_RESPONSE_TYPE_TOKEN = new TypeToken<Map<String, String>>(){};
    private static final TypeToken<Map<String, List<String>>> AUTH_URL_RESPONSE_TYPE_TOKEN = new TypeToken<Map<String, List<String>>>(){};
    private long expirationTime;
    private AccessToken accessToken;
    private URI pingURI;
    private URI authURI;
    private Boolean authEnabled;
    private boolean verifySSLCert;

    protected abstract Multimap<String, String> getAuthenticationHeaders();

    @Override
    public void invalidateToken() {
        this.accessToken = null;
    }

    @Override
    public boolean isAuthEnabled() throws IOException {
        if (this.authEnabled == null) {
            String strAuthURI = this.fetchAuthURI();
            this.authEnabled = StringUtils.isNotEmpty((String)strAuthURI);
            if (this.authEnabled.booleanValue()) {
                this.authURI = URI.create(strAuthURI);
            }
        }
        return this.authEnabled;
    }

    @Override
    public void setConnectionInfo(String host, int port, boolean ssl) {
        if (this.pingURI != null) {
            throw new IllegalStateException("Connection info is already configured!");
        }
        this.pingURI = URI.create(String.format("%s://%s:%d/ping", ssl ? HTTPS_PROTOCOL : HTTP_PROTOCOL, host, port));
    }

    @Override
    public AccessToken getAccessToken() throws IOException {
        if (!this.isAuthEnabled()) {
            return null;
        }
        if (this.accessToken == null || this.isTokenExpired()) {
            long requestTime = System.currentTimeMillis();
            this.accessToken = this.fetchAccessToken();
            this.expirationTime = requestTime + TimeUnit.SECONDS.toMillis(this.accessToken.getExpiresIn()) - 5000L;
            LOG.debug("Received the access token successfully. Expiration date is {}.", (Object)new Date(this.expirationTime));
        }
        return this.accessToken;
    }

    public AccessToken get() {
        try {
            return this.getAccessToken();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected URI getAuthURI() {
        return this.authURI;
    }

    public boolean isVerifySSLCert() {
        return this.verifySSLCert;
    }

    protected void setVerifySSLCert(boolean verifySSLCert) {
        this.verifySSLCert = verifySSLCert;
    }

    private boolean isTokenExpired() {
        return this.expirationTime < System.currentTimeMillis();
    }

    private String fetchAuthURI() throws IOException {
        if (this.pingURI == null) {
            throw new IllegalStateException("Connection information not set!");
        }
        LOG.debug("Try to get the authentication URI from the gateway server: {}.", (Object)this.pingURI);
        HttpResponse response = HttpRequests.execute((HttpRequest)HttpRequest.get((URL)this.pingURI.toURL()).build(), (HttpRequestConfig)this.getHttpRequestConfig());
        LOG.debug("Got response {} - {} from {}", new Object[]{response.getResponseCode(), response.getResponseMessage(), this.pingURI});
        if (response.getResponseCode() != 401) {
            return "";
        }
        Map responseMap = (Map)ObjectResponse.fromJsonBody((HttpResponse)response, AUTH_URL_RESPONSE_TYPE_TOKEN).getResponseObject();
        LOG.debug("Response map from gateway server: {}", (Object)responseMap);
        List uriList = (List)responseMap.get(AUTH_URI_KEY);
        if (uriList == null || uriList.isEmpty()) {
            throw new IOException("Authentication servers list is empty.");
        }
        String result = (String)uriList.get(RANDOM.nextInt(uriList.size()));
        return result;
    }

    private AccessToken execute(HttpRequest request) throws IOException {
        HttpResponse response = HttpRequests.execute((HttpRequest)request, (HttpRequestConfig)this.getHttpRequestConfig());
        LOG.debug("Got response {} - {} from {}", new Object[]{response.getResponseCode(), response.getResponseMessage(), this.pingURI});
        if (response.getResponseCode() != 200) {
            throw new HttpFailureException(response.getResponseMessage(), response.getResponseCode());
        }
        Map responseMap = (Map)ObjectResponse.fromJsonBody((HttpResponse)response, ACCESS_TOKEN_RESPONSE_TYPE_TOKEN).getResponseObject();
        String tokenValue = (String)responseMap.get(ACCESS_TOKEN_KEY);
        String tokenType = (String)responseMap.get(TOKEN_TYPE_KEY);
        String expiresInStr = (String)responseMap.get(EXPIRES_IN_KEY);
        LOG.debug("Response map from auth server: {}", (Object)responseMap);
        if (StringUtils.isEmpty((String)tokenValue) || StringUtils.isEmpty((String)tokenType) || StringUtils.isEmpty((String)expiresInStr)) {
            throw new IOException("Unexpected response was received from the authentication server.");
        }
        return new AccessToken(tokenValue, Long.valueOf(expiresInStr), tokenType);
    }

    private AccessToken fetchAccessToken() throws IOException {
        LOG.debug("Authentication is enabled in the gateway server. Authentication URI {}.", (Object)this.getAuthURI());
        return this.execute(HttpRequest.get((URL)this.getAuthURI().toURL()).addHeaders(this.getAuthenticationHeaders()).build());
    }

    private HttpRequestConfig getHttpRequestConfig() {
        return new HttpRequestConfig(0, 0, this.isVerifySSLCert());
    }
}

