/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.security.authentication.client.basic;

import co.cask.cdap.security.authentication.client.AbstractAuthenticationClient;
import co.cask.cdap.security.authentication.client.Credential;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthenticationClient
extends AbstractAuthenticationClient {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthenticationClient.class);
    public static final String VERIFY_SSL_CERT_PROP_NAME = "security.auth.client.verify.ssl.cert";
    private static final String AUTHENTICATION_HEADER_PREFIX_BASIC = "Basic ";
    private static final String USERNAME_PROP_NAME = "security.auth.client.username";
    private static final String PASSWORD_PROP_NAME = "security.auth.client.password";
    private String username;
    private String password;
    private final List<Credential> credentials = ImmutableList.of((Object)new Credential("security.auth.client.username", "Username for basic authentication.", false), (Object)new Credential("security.auth.client.password", "Password for basic authentication.", true));

    @Override
    public void configure(Properties properties) {
        if (StringUtils.isNotEmpty((String)this.username) || StringUtils.isNotEmpty((String)this.password)) {
            throw new IllegalStateException("Client is already configured!");
        }
        this.username = properties.getProperty(USERNAME_PROP_NAME);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)this.username), (Object)"The username property cannot be empty.");
        this.password = properties.getProperty(PASSWORD_PROP_NAME);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)this.password), (Object)"The password property cannot be empty.");
        boolean verifySSLCert = Boolean.valueOf(properties.getProperty(VERIFY_SSL_CERT_PROP_NAME, "true"));
        this.setVerifySSLCert(verifySSLCert);
        if (!verifySSLCert) {
            LOG.info("Disabling SSL certificate check.");
        }
        LOG.debug("Basic authentication client is configured successfully.");
    }

    @Override
    public List<Credential> getRequiredCredentials() {
        return this.credentials;
    }

    @Override
    protected Multimap<String, String> getAuthenticationHeaders() {
        if (StringUtils.isEmpty((String)this.username) || StringUtils.isEmpty((String)this.password)) {
            throw new IllegalStateException("Base authentication client is not configured!");
        }
        String auth = Base64.encodeBase64String((byte[])String.format("%s:%s", this.username, this.password).getBytes());
        auth = auth.replaceAll("(\r|\n)", "");
        return ImmutableMultimap.of((Object)"Authorization", (Object)(AUTHENTICATION_HEADER_PREFIX_BASIC + auth));
    }
}

