/*
 * Decompiled with CFR 0.152.
 */
package co.igorski.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junitpioneer.jupiter.TempDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={TempDirectory.class})
class BuildProperties {
    private static final String DEFAULT_BUILD_VERSION = "<undefined version>";
    private static final String BUILD_VERSION_KEY = "version";
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildProperties.class);
    private String buildVersion;

    BuildProperties(String buildPropertiesFile) {
        Properties properties = new Properties();
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(buildPropertiesFile);){
            properties.load(in);
        }
        catch (IOException | NullPointerException e) {
            LOGGER.warn("Failed to read client properties file!", (Throwable)e);
        }
        this.buildVersion = properties.getProperty(BUILD_VERSION_KEY, DEFAULT_BUILD_VERSION);
        if (this.buildVersion.contains("${project.version}")) {
            this.buildVersion = DEFAULT_BUILD_VERSION;
        }
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }
}

