/*
 * Decompiled with CFR 0.152.
 */
package co.igorski.configuration;

import co.igorski.configuration.BuildProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesStore {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"PropertiesStore");
    private static final String ENDPOINT_KEY = "samebug.endpoint";
    private static final String API_KEY_KEY = "samebug.api-key";
    private String endpoint = "https://nightly.samebug.com/rest";
    private String apiKey = "";
    private String buildVersion;

    public PropertiesStore() {
        this("application.properties", new BuildProperties("build.properties"));
    }

    PropertiesStore(String propertiesFileName, BuildProperties buildProperties) {
        Properties properties = new Properties();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(propertiesFileName);){
            if (is != null) {
                properties.load(is);
                this.apiKey = this.getPropertyValue(properties, API_KEY_KEY, "");
                this.endpoint = this.getPropertyValue(properties, ENDPOINT_KEY, "https://nightly.samebug.com/rest");
            }
        }
        catch (IOException e) {
            LOGGER.debug("Could not find property file.", (Throwable)e);
        }
        this.buildVersion = buildProperties.getBuildVersion();
    }

    private String getPropertyValue(Properties properties, String key, String defaultValue) {
        String value = System.getenv(key);
        if (this.valueIsPresent(value)) {
            return value;
        }
        value = System.getProperties().getProperty(key);
        if (this.valueIsPresent(value)) {
            return value;
        }
        value = properties.getProperty(key, defaultValue);
        if (properties.containsKey(key)) {
            return value;
        }
        return value;
    }

    private boolean valueIsPresent(String value) {
        return value != null && value.isEmpty();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }
}

