/*
 * Decompiled with CFR 0.152.
 */
package co.igorski.extension;

import co.igorski.model.CrashResponse;
import co.igorski.services.SamebugProxy;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamebugExtension
implements AfterEachCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamebugExtension.class);
    private final SamebugProxy samebugProxy;

    public SamebugExtension() {
        this(new SamebugProxy());
    }

    private SamebugExtension(SamebugProxy samebugProxy) {
        this.samebugProxy = samebugProxy;
    }

    public void afterEach(ExtensionContext extensionContext) {
        CrashResponse crashResponse;
        Optional throwable = extensionContext.getExecutionException();
        if (throwable.isPresent() && (crashResponse = this.samebugProxy.getSamebugRequest((Throwable)throwable.get())) != null && crashResponse.getData() != null) {
            LOGGER.info("Please visit https://nightly.samebug.com/searches/" + crashResponse.getData().getId() + " for more info.");
        }
    }
}

