/*
 * Decompiled with CFR 0.152.
 */
package co.igorski.services;

import co.igorski.clients.SamebugClient;
import co.igorski.configuration.PropertiesStore;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

class SamebugClientFactory {
    private final PropertiesStore propertiesStore;
    private SamebugClient samebugClient;

    SamebugClientFactory(PropertiesStore propertiesStore) {
        this.propertiesStore = propertiesStore;
    }

    SamebugClient getInstance() {
        if (this.samebugClient == null) {
            this.createSameBugClient();
        }
        return this.samebugClient;
    }

    private void createSameBugClient() {
        ResteasyClient client = new ResteasyClientBuilder().build();
        ResteasyWebTarget webTarget = client.target(UriBuilder.fromPath((String)this.propertiesStore.getEndpoint()));
        webTarget.register(requestContext -> {
            requestContext.getHeaders().add((Object)"X-Samebug-ApiKey", (Object)this.propertiesStore.getApiKey());
            requestContext.getHeaders().add((Object)"User-Agent", (Object)("JUnit-Extension/" + this.propertiesStore.getBuildVersion()));
        });
        this.samebugClient = (SamebugClient)webTarget.proxy(SamebugClient.class);
    }
}

