/*
 * Decompiled with CFR 0.152.
 */
package co.igorski.services;

import co.igorski.clients.SamebugClient;
import co.igorski.configuration.PropertiesStore;
import co.igorski.model.CrashResponse;
import co.igorski.model.SamebugRequest;
import co.igorski.services.ExceptionRequestFactory;
import co.igorski.services.SamebugClientFactory;
import co.igorski.services.SamebugRequestFactory;
import javax.ws.rs.ProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamebugProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamebugProxy.class);
    private final SamebugClient samebugClient;
    private final ExceptionRequestFactory samebugRequestFactory;

    public SamebugProxy() {
        this(new SamebugRequestFactory(), new SamebugClientFactory(new PropertiesStore()));
    }

    SamebugProxy(ExceptionRequestFactory samebugRequestFactory, SamebugClientFactory samebugClientFactory) {
        this.samebugRequestFactory = samebugRequestFactory;
        this.samebugClient = samebugClientFactory.getInstance();
    }

    public CrashResponse getSamebugRequest(Throwable throwable) {
        SamebugRequest samebugRequest = this.samebugRequestFactory.createInstance(throwable);
        CrashResponse crashResponse = null;
        try {
            crashResponse = this.samebugClient.getCrashReport(samebugRequest);
        }
        catch (ProcessingException pe) {
            LOGGER.error("Error sending Samebug request.", (Throwable)pe);
        }
        return crashResponse;
    }
}

