/*
 * Decompiled with CFR 0.152.
 */
package co.igorski.services;

import co.igorski.model.Cause;
import co.igorski.model.Frame;
import co.igorski.model.Method;
import co.igorski.model.SamebugRequest;
import co.igorski.services.ExceptionRequestFactory;
import java.util.ArrayList;
import java.util.List;

public class SamebugRequestFactory
implements ExceptionRequestFactory {
    @Override
    public SamebugRequest createInstance(Throwable e) {
        SamebugRequest samebugRequest = new SamebugRequest();
        samebugRequest.setMessage(e.getMessage());
        samebugRequest.setTypeName(e.getClass().getTypeName());
        samebugRequest.setFrames(this.getFrames(e));
        Throwable realCause = e.getCause();
        if (realCause != null) {
            Cause cause = new Cause();
            cause.setMessage(realCause.getMessage());
            cause.setTypeName(realCause.getClass().getTypeName());
            cause.setFrames(this.getFrames(realCause));
            samebugRequest.setCause(cause);
        }
        return samebugRequest;
    }

    private List<Frame> getFrames(Throwable e) {
        StackTraceElement[] stackTraceElements;
        ArrayList<Frame> frames = new ArrayList<Frame>();
        for (StackTraceElement element : stackTraceElements = e.getStackTrace()) {
            Frame frame = new Frame();
            String fullClassName = element.getClassName();
            String[] parts = fullClassName.split("\\.");
            String className = parts[parts.length - 1];
            String packageName = fullClassName.substring(0, fullClassName.indexOf(className) - 1);
            Method method = new Method();
            method.setPackageName(packageName);
            method.setClassName(className);
            method.setMethodName(element.getMethodName());
            frame.setMethod(method);
            frame.setLocation(element.getFileName() + ":" + element.getLineNumber());
            frames.add(frame);
        }
        return frames;
    }
}

