/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.util.TestUtil;
import java.net.URI;
import java.util.Date;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.SlingParameter;
import org.apache.sling.testing.clients.util.URLParameterBuilder;
import org.codehaus.jackson.JsonNode;

public class JsonClient
extends CQClient {
    public JsonClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public JsonClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public JsonNode getPages(String parentPath) throws ClientException {
        String path = parentPath + ".pages.json?tidy=true&predicate=page";
        SlingHttpResponse exec = this.doGet(path, new int[]{200});
        return JsonUtils.getJsonNodeFromString((String)exec.getContent());
    }

    public JsonNode getPageReferences(String[] pagePaths) throws ClientException {
        String getPath = "/bin/wcm/references";
        URLParameterBuilder params = URLParameterBuilder.create().add("tidy", Boolean.TRUE.toString()).add(new SlingParameter("path").values(pagePaths).multiple().toNameValuePairs());
        SlingHttpResponse exec = this.doGet(getPath, params.getList(), new int[]{200});
        return JsonUtils.getJsonNodeFromString((String)exec.getContent());
    }

    public JsonNode getMoveReferences(String pagePath, int ... expectedStatus) throws ClientException {
        if (pagePath == null) {
            throw new IllegalArgumentException("pagePath parameter must not be null");
        }
        String postPath = "/bin/wcm/heavymove";
        SlingHttpResponse exec = this.doGet(postPath, URLParameterBuilder.create().add("path", pagePath).getList(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return JsonUtils.getJsonNodeFromString((String)exec.getContent());
    }

    public JsonNode getLanguages(String sitePath, boolean deep) throws ClientException {
        if (sitePath == null) {
            throw new IllegalArgumentException("sitePath parameter must not be null");
        }
        String getPath = sitePath + ".languages.json";
        SlingHttpResponse exec = this.doGet(getPath, URLParameterBuilder.create().add("deep", Boolean.toString(deep)).getList(), new int[]{200});
        return JsonUtils.getJsonNodeFromString((String)exec.getContent());
    }

    public JsonNode getVersions(String pagePath, boolean showChildren, int ... expectedStatus) throws ClientException {
        String getPath = "/bin/wcm/versions.json";
        SlingHttpResponse exec = this.doGet(getPath, URLParameterBuilder.create().add("path", pagePath).add("showChildren", Boolean.toString(showChildren)).getList(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return JsonUtils.getJsonNodeFromString((String)exec.getContent());
    }

    public JsonNode getVersionTree(String pagePath, String node, Date date, int ... expectedStatus) throws ClientException {
        String getPath = "/bin/wcm/versiontree";
        SlingHttpResponse exec = this.doGet(getPath, URLParameterBuilder.create().add("path", pagePath).add("node", node).add("date", date == null ? null : TestUtil.ISO_DATETIME_TIME_ZONE_FORMAT.format(date)).getList(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        return JsonUtils.getJsonNodeFromString((String)exec.getContent());
    }

    public JsonNode getUserGeneratedPages(String ugcBasePath, int limit, int start, String predicate, String view) throws ClientException {
        String getPath = "/content/usergenerated" + ugcBasePath + ".ugc.json";
        URLParameterBuilder params = URLParameterBuilder.create();
        params.add("limit", Integer.valueOf(limit).toString());
        params.add("start", Integer.valueOf(start).toString());
        params.add("predicate", predicate);
        if (view != null) {
            params.add("view", view);
        }
        SlingHttpResponse exec = this.doGet(getPath, params.getList(), new int[]{200});
        return JsonUtils.getJsonNodeFromString((String)exec.getContent());
    }
}

