/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.assertion;

import com.adobe.cq.testing.client.SecurityClient;
import com.adobe.cq.testing.client.security.Authorizable;
import com.adobe.cq.testing.client.security.Group;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.testing.clients.ClientException;
import org.codehaus.jackson.JsonNode;
import org.junit.Assert;

public class SecurityAssert {
    private static final String SCHEMA_ACE = "/schemas/json/ace-schema.json";
    public static final String REP_POLICY = "rep:policy";

    public static <T extends Authorizable> void assertIsMemberOf(Group authorizableMemberOf, T authorizableMember) throws ClientException, InterruptedException {
        Assert.assertTrue((String)("Authorizable '" + authorizableMember.getId() + "' should be member of group " + authorizableMemberOf.getId() + "."), (boolean)authorizableMemberOf.hasGroupMember(authorizableMember));
    }

    public static <T extends Authorizable> void assertIsNotMember(Group authorizableMemberOf, T authorizableMember) throws ClientException, InterruptedException {
        Map<String, Authorizable> members = authorizableMemberOf.getMembers();
        Assert.assertFalse((String)("Authorizable '" + authorizableMember.getId() + "' may not be member of group " + authorizableMemberOf.getId() + "."), (boolean)members.containsKey(authorizableMember.getId()));
    }

    public static <T extends Authorizable> void assertIsNotMemberOf(Group authorizableMemberOf, T authorizableMember) throws ClientException, InterruptedException {
        Map<String, Authorizable> memberOf = authorizableMember.getMemberOf();
        Assert.assertFalse((String)("Authorizable '" + authorizableMember.getId() + "' may not be member of group " + authorizableMemberOf.getId() + "."), (boolean)memberOf.containsKey(authorizableMemberOf.getId()));
    }

    public static <T extends SecurityClient> void assertValidUser(T client, String userPath) throws ClientException {
        if (client == null) {
            throw new IllegalArgumentException("Client may not be null!");
        }
        if (userPath == null) {
            throw new IllegalArgumentException("Path to user may not be null!");
        }
        JsonNode userNode = client.doGetJson(userPath, -1, new int[0]);
        Assert.assertEquals((String)("'jcr:primaryType' for '" + userPath + "' is not 'rep:User'!"), (Object)"rep:User", (Object)userNode.get("jcr:primaryType").getValueAsText());
        SecurityAssert.assertACE(client, userPath);
    }

    public static <T extends SecurityClient> void assertACE(T client, String userPath) throws ClientException {
        if (client == null) {
            throw new IllegalArgumentException("Client may not be null!");
        }
        if (userPath == null) {
            throw new IllegalArgumentException("Path to user may not be null!");
        }
        JsonNode userNode = client.doGetJson(userPath, -1, new int[0]);
        JsonNode policyNode = userNode.get(REP_POLICY);
        Assert.assertFalse((String)("'rep:policy' node for '" + userPath + "' is missing!"), (boolean)policyNode.isMissingNode());
        Assert.assertEquals((String)("'jcr:primaryType' for '" + userPath + "/" + REP_POLICY + "' is wrong!"), (Object)"rep:ACL", (Object)policyNode.get("jcr:primaryType").getValueAsText());
        JsonNode allowNode = policyNode.get("allow");
        JsonNode denyNode = policyNode.get("deny");
        Assert.assertTrue((String)("'rep:policy' node for '" + userPath + "' has no entries (allow / deny)!"), (!allowNode.isMissingNode() || !denyNode.isMissingNode() ? 1 : 0) != 0);
        SecurityAssert.assertACENode(userPath, allowNode);
        if (denyNode != null) {
            SecurityAssert.assertACENode(userPath, denyNode);
        }
    }

    public static void assertACENode(String userPath, JsonNode aceNode) {
        Assert.assertEquals((String)("'jcr:primaryType' for '" + userPath + "' is not 'rep:GrantACE'!"), (Object)"rep:GrantACE", (Object)aceNode.get("jcr:primaryType").getValueAsText());
    }

    public static <T extends SecurityClient> void assertValidGroup(T client, String groupPath) throws ClientException {
        if (client == null) {
            throw new IllegalArgumentException("Client may not be null!");
        }
        if (groupPath == null) {
            throw new IllegalArgumentException("Path to group may not be null!");
        }
        JsonNode userNode = client.doGetJson(groupPath, 0, new int[0]);
        Assert.assertEquals((String)("'jcr:primaryType' for '" + groupPath + "' is not 'rep:Group'!"), (Object)"rep:Group", (Object)userNode.get("jcr:primaryType").getValueAsText());
    }

    public static <T extends SecurityClient> void assertProfile(T client, String authorizablePath, HashMap<String, String> expectedProps) throws ClientException {
        JsonNode userNode = client.doGetJson(authorizablePath, -1, new int[0]);
        JsonNode profileNode = userNode.path("profile");
        Assert.assertFalse((String)("UserProfile node for '" + authorizablePath + "' is missing!"), (boolean)profileNode.isMissingNode());
        String expectedResourceType = "nt:unstructured";
        Assert.assertEquals((String)("'jcr:primaryType' for '" + authorizablePath + "/profile' is wrong'!"), (Object)expectedResourceType, (Object)profileNode.get("jcr:primaryType").getValueAsText());
        if (expectedProps == null) {
            return;
        }
        for (String propName : expectedProps.keySet()) {
            Assert.assertNotNull((String)("Users property '" + propName + "' does not exist in profile."), (Object)profileNode.get(propName));
            String expectedValue = expectedProps.get(propName);
            Assert.assertEquals((String)("Users property '" + propName + "' does not match expected value in profile node."), (Object)expectedValue, (Object)profileNode.get(propName).getValueAsText());
        }
    }
}

