/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.rules;

import com.adobe.cq.testing.client.CQClient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.util.ResourceUtil;
import org.apache.sling.testing.junit.rules.instance.Instance;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Page
extends ExternalResource {
    private Logger logger = LoggerFactory.getLogger(Page.class);
    private static final String SITE_ROOT_PATH = "/content/test-site";
    private static final String TEMPLATE_ROOT_PATH = "/conf/test-site";
    private static final String TEMPLATE_PATH = "/conf/test-site/settings/wcm/templates/content-page";
    private final Instance quickstartRule;
    private ThreadLocal<String> parentPath = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return Page.this.initialParentPath();
        }
    };
    private ThreadLocal<String> name = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return Page.this.initialName();
        }
    };
    private ThreadLocal<String> templatePath = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return Page.this.initialTemplatePath();
        }
    };

    public Page(Instance quickstartRule) {
        this.quickstartRule = quickstartRule;
    }

    protected void before() throws ClientException {
        this.prepare();
        this.getClient().createPage(this.getName(), this.getTitle(), this.getParentPath(), this.getTemplatePath(), new int[0]);
    }

    protected void after() {
        try {
            this.getClient().deletePage(new String[]{this.getPath()}, true, false, new int[0]);
        }
        catch (Exception e) {
            this.logger.error("Unable to delete the page", (Throwable)e);
        }
    }

    protected String initialParentPath() {
        return SITE_ROOT_PATH;
    }

    protected String initialName() {
        return "testpage_" + UUID.randomUUID();
    }

    protected String initialTemplatePath() {
        return TEMPLATE_PATH;
    }

    protected CQClient getClient() throws ClientException {
        return (CQClient)this.quickstartRule.getAdminClient(CQClient.class);
    }

    protected void prepare() throws ClientException {
        if (this.getClient().exists(SITE_ROOT_PATH)) {
            this.logger.debug("Site already present, skipping installation");
            return;
        }
        try {
            InputStream templateStream = ResourceUtil.getResourceAsStream((String)"/com/adobe/cq/testing/junit/rules/template.json");
            String template = IOUtils.toString((InputStream)templateStream, (Charset)StandardCharsets.UTF_8);
            this.getClient().importContent(TEMPLATE_ROOT_PATH, "json", template, new int[]{201});
            this.logger.info("Created test template in {}", (Object)TEMPLATE_ROOT_PATH);
        }
        catch (IOException e) {
            throw new ClientException("Failed to create test template.", (Throwable)e);
        }
        try {
            InputStream siteStream = ResourceUtil.getResourceAsStream((String)"/com/adobe/cq/testing/junit/rules/site.json");
            String site = IOUtils.toString((InputStream)siteStream, (Charset)StandardCharsets.UTF_8);
            this.getClient().importContent(SITE_ROOT_PATH, "json", site, new int[]{201});
            this.logger.info("Created test site {}", (Object)SITE_ROOT_PATH);
        }
        catch (IOException e) {
            throw new ClientException("Failed to create test site.", (Throwable)e);
        }
    }

    public String getTitle() {
        return "Test Page";
    }

    public String getName() {
        return this.name.get();
    }

    public String getParentPath() {
        return this.parentPath.get();
    }

    public String getTemplatePath() {
        return this.templatePath.get();
    }

    public final String getPath() {
        return this.getParentPath() + "/" + this.getName();
    }
}

