/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.polling;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.codehaus.jackson.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceReadyPoller
extends Polling {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceReadyPoller.class);
    private static final String TEST_JSP_LOCATION = "/libs/granite/core/components/login/test.json.jsp";
    private static final String TEST_URL = "/libs/granite/core/content/login.test.json";
    private SlingClient client;

    public InstanceReadyPoller(SlingClient client) {
        this.client = client;
    }

    public Boolean call() throws ClientException {
        LOG.debug("checking /libs/granite/core/content/login.test.json");
        SlingHttpResponse exec = this.client.doGet(TEST_URL, new int[]{200});
        JsonNode resultNode = JsonUtils.getJsonNodeFromString((String)exec.getContent());
        JsonNode readyProperty = resultNode.get("ready");
        boolean isReady = readyProperty.getBooleanValue();
        JsonNode indexingProperty = resultNode.get("indexing");
        boolean isIndexing = indexingProperty.getBooleanValue();
        return isReady && !isIndexing;
    }

    public static void installTest(SlingClient client) throws IOException, ClientException {
        int bytesRead;
        File tmpFile = File.createTempFile("_install_", ".jsp");
        FileOutputStream fos = new FileOutputStream(tmpFile);
        InputStream fis = InstanceReadyPoller.class.getResourceAsStream("test.json.jsp");
        byte[] buffer = new byte[8192];
        while ((bytesRead = fis.read(buffer)) != -1) {
            fos.write(buffer, 0, bytesRead);
        }
        fis.close();
        fos.close();
        client.upload(tmpFile, "text/plain", TEST_JSP_LOCATION, false, new int[]{200});
        tmpFile.delete();
    }

    public static void uninstallTest(SlingClient client) throws ClientException {
        client.deletePath(TEST_JSP_LOCATION, new int[0]);
    }
}

