/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.threads.runs;

import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.threads.ThreadParam;
import com.alibaba.dashscope.threads.runs.RunParam;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class ThreadAndRunParam
extends RunParam {
    private ThreadParam thread;

    @Override
    public JsonObject getHttpBody() {
        JsonObject requestObject = super.getHttpBody();
        if (this.thread != null) {
            requestObject.add("thread", (JsonElement)this.thread.getHttpBody());
        }
        return requestObject;
    }

    @Override
    public void validate() throws InputRequiredException {
        if (this.assistantId == null || this.assistantId.isEmpty()) {
            throw new InputRequiredException("The assistantId must be set");
        }
        if (this.responseFormat != null && this.responseFormat instanceof String && ((String)this.responseFormat).equals("json_object")) {
            return;
        }
        throw new InputRequiredException("The response format only support json_object");
    }

    protected ThreadAndRunParam(ThreadAndRunParamBuilder<?, ?> b) {
        super((RunParam.RunParamBuilder<?, ?>)b);
        this.thread = ((ThreadAndRunParamBuilder)b).thread;
    }

    public static ThreadAndRunParamBuilder<?, ?> builder() {
        return new ThreadAndRunParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadAndRunParam)) {
            return false;
        }
        ThreadAndRunParam other = (ThreadAndRunParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThreadParam this$thread = this.getThread();
        ThreadParam other$thread = other.getThread();
        return !(this$thread == null ? other$thread != null : !((Object)this$thread).equals(other$thread));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ThreadAndRunParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ThreadParam $thread = this.getThread();
        result = result * 59 + ($thread == null ? 43 : ((Object)$thread).hashCode());
        return result;
    }

    public ThreadParam getThread() {
        return this.thread;
    }

    public void setThread(ThreadParam thread) {
        this.thread = thread;
    }

    @Override
    public String toString() {
        return "ThreadAndRunParam(thread=" + this.getThread() + ")";
    }

    private static final class ThreadAndRunParamBuilderImpl
    extends ThreadAndRunParamBuilder<ThreadAndRunParam, ThreadAndRunParamBuilderImpl> {
        private ThreadAndRunParamBuilderImpl() {
        }

        @Override
        protected ThreadAndRunParamBuilderImpl self() {
            return this;
        }

        @Override
        public ThreadAndRunParam build() {
            return new ThreadAndRunParam(this);
        }
    }

    public static abstract class ThreadAndRunParamBuilder<C extends ThreadAndRunParam, B extends ThreadAndRunParamBuilder<C, B>>
    extends RunParam.RunParamBuilder<C, B> {
        private ThreadParam thread;

        public B thread(ThreadParam thread) {
            this.thread = thread;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ThreadAndRunParam.ThreadAndRunParamBuilder(super=" + super.toString() + ", thread=" + this.thread + ")";
        }
    }
}

