/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource.undo;

import com.alibaba.fescar.common.exception.NotSupportYetException;
import com.alibaba.fescar.common.exception.ShouldNeverHappenException;
import com.alibaba.fescar.rm.datasource.undo.AbstractUndoExecutor;
import com.alibaba.fescar.rm.datasource.undo.SQLUndoLog;
import com.alibaba.fescar.rm.datasource.undo.mysql.MySQLUndoDeleteExecutor;
import com.alibaba.fescar.rm.datasource.undo.mysql.MySQLUndoInsertExecutor;
import com.alibaba.fescar.rm.datasource.undo.mysql.MySQLUndoUpdateExecutor;

public class UndoExecutorFactory {
    public static AbstractUndoExecutor getUndoExecutor(String dbType, SQLUndoLog sqlUndoLog) {
        if (!dbType.equals("mysql")) {
            throw new NotSupportYetException(dbType);
        }
        switch (sqlUndoLog.getSqlType()) {
            case INSERT: {
                return new MySQLUndoInsertExecutor(sqlUndoLog);
            }
            case UPDATE: {
                return new MySQLUndoUpdateExecutor(sqlUndoLog);
            }
            case DELETE: {
                return new MySQLUndoDeleteExecutor(sqlUndoLog);
            }
        }
        throw new ShouldNeverHappenException();
    }
}

