/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.http;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.config.http.HttpAgent;
import com.alibaba.nacos.client.config.impl.HttpSimpleClient;
import com.alibaba.nacos.client.config.impl.ServerListManager;
import com.alibaba.nacos.client.config.impl.SpasAdapter;
import com.alibaba.nacos.client.identify.StsConfig;
import com.alibaba.nacos.client.security.SecurityProxy;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.client.utils.ParamUtil;
import com.alibaba.nacos.client.utils.TemplateUtils;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ServerHttpAgent
implements HttpAgent {
    private static final Logger LOGGER = LogUtils.logger(ServerHttpAgent.class);
    private SecurityProxy securityProxy;
    private String namespaceId;
    private final long securityInfoRefreshIntervalMills = TimeUnit.SECONDS.toMillis(5L);
    private ScheduledExecutorService executorService;
    private String accessKey;
    private String secretKey;
    private String encode;
    private int maxRetry = 3;
    private volatile StsCredential stsCredential;
    final ServerListManager serverListMgr;

    @Override
    public HttpSimpleClient.HttpResult httpGet(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        boolean isSsl = false;
        this.injectSecurityInfo(paramValues);
        String currentServerAddr = this.serverListMgr.getCurrentServerAddr();
        int maxRetry = this.maxRetry;
        do {
            try {
                List<String> newHeaders = this.getSpasHeaders(paramValues);
                if (headers != null) {
                    newHeaders.addAll(headers);
                }
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpGet(this.getUrl(currentServerAddr, path), newHeaders, paramValues, encoding, readTimeoutMs, false);
                if (result.code != 500 && result.code != 502 && result.code != 503) {
                    this.serverListMgr.updateCurrentServerAddr(currentServerAddr);
                    return result;
                }
                LOGGER.error("[NACOS ConnectException] currentServerAddr: {}, httpCode: {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)result.code);
            }
            catch (ConnectException connectException) {
                LOGGER.error("[NACOS ConnectException httpGet] currentServerAddr:{}, err : {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)connectException.getMessage());
            }
            catch (SocketTimeoutException socketTimeoutException) {
                LOGGER.error("[NACOS SocketTimeoutException httpGet] currentServerAddr:{}\uff0c err : {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)socketTimeoutException.getMessage());
            }
            catch (IOException ioException) {
                LOGGER.error("[NACOS IOException httpGet] currentServerAddr: " + this.serverListMgr.getCurrentServerAddr(), (Throwable)ioException);
                throw ioException;
            }
            if (this.serverListMgr.getIterator().hasNext()) {
                currentServerAddr = this.serverListMgr.getIterator().next();
                continue;
            }
            if (--maxRetry < 0) {
                throw new ConnectException("[NACOS HTTP-GET] The maximum number of tolerable server reconnection errors has been reached");
            }
            this.serverListMgr.refreshCurrentServerAddr();
        } while (System.currentTimeMillis() <= endTime);
        LOGGER.error("no available server");
        throw new ConnectException("no available server");
    }

    @Override
    public HttpSimpleClient.HttpResult httpPost(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        boolean isSsl = false;
        this.injectSecurityInfo(paramValues);
        String currentServerAddr = this.serverListMgr.getCurrentServerAddr();
        int maxRetry = this.maxRetry;
        do {
            try {
                List<String> newHeaders = this.getSpasHeaders(paramValues);
                if (headers != null) {
                    newHeaders.addAll(headers);
                }
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpPost(this.getUrl(currentServerAddr, path), newHeaders, paramValues, encoding, readTimeoutMs, isSsl);
                if (result.code != 500 && result.code != 502 && result.code != 503) {
                    this.serverListMgr.updateCurrentServerAddr(currentServerAddr);
                    return result;
                }
                LOGGER.error("[NACOS ConnectException] currentServerAddr: {}, httpCode: {}", (Object)currentServerAddr, (Object)result.code);
            }
            catch (ConnectException connectException) {
                LOGGER.error("[NACOS ConnectException httpPost] currentServerAddr: {}, err : {}", (Object)currentServerAddr, (Object)connectException.getMessage());
            }
            catch (SocketTimeoutException socketTimeoutException) {
                LOGGER.error("[NACOS SocketTimeoutException httpPost] currentServerAddr: {}\uff0c err : {}", (Object)currentServerAddr, (Object)socketTimeoutException.getMessage());
            }
            catch (IOException ioe) {
                LOGGER.error("[NACOS IOException httpPost] currentServerAddr: " + currentServerAddr, (Throwable)ioe);
                throw ioe;
            }
            if (this.serverListMgr.getIterator().hasNext()) {
                currentServerAddr = this.serverListMgr.getIterator().next();
                continue;
            }
            if (--maxRetry < 0) {
                throw new ConnectException("[NACOS HTTP-POST] The maximum number of tolerable server reconnection errors has been reached");
            }
            this.serverListMgr.refreshCurrentServerAddr();
        } while (System.currentTimeMillis() <= endTime);
        LOGGER.error("no available server, currentServerAddr : {}", (Object)currentServerAddr);
        throw new ConnectException("no available server, currentServerAddr : " + currentServerAddr);
    }

    @Override
    public HttpSimpleClient.HttpResult httpDelete(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        boolean isSsl = false;
        this.injectSecurityInfo(paramValues);
        String currentServerAddr = this.serverListMgr.getCurrentServerAddr();
        int maxRetry = this.maxRetry;
        do {
            try {
                List<String> newHeaders = this.getSpasHeaders(paramValues);
                if (headers != null) {
                    newHeaders.addAll(headers);
                }
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpDelete(this.getUrl(currentServerAddr, path), newHeaders, paramValues, encoding, readTimeoutMs, isSsl);
                if (result.code != 500 && result.code != 502 && result.code != 503) {
                    this.serverListMgr.updateCurrentServerAddr(currentServerAddr);
                    return result;
                }
                LOGGER.error("[NACOS ConnectException] currentServerAddr: {}, httpCode: {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)result.code);
            }
            catch (ConnectException connectException) {
                connectException.printStackTrace();
                LOGGER.error("[NACOS ConnectException httpDelete] currentServerAddr:{}, err : {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)connectException.getMessage());
            }
            catch (SocketTimeoutException stoe) {
                stoe.printStackTrace();
                LOGGER.error("[NACOS SocketTimeoutException httpDelete] currentServerAddr:{}\uff0c err : {}", (Object)this.serverListMgr.getCurrentServerAddr(), (Object)stoe.getMessage());
            }
            catch (IOException ioe) {
                LOGGER.error("[NACOS IOException httpDelete] currentServerAddr: " + this.serverListMgr.getCurrentServerAddr(), (Throwable)ioe);
                throw ioe;
            }
            if (this.serverListMgr.getIterator().hasNext()) {
                currentServerAddr = this.serverListMgr.getIterator().next();
                continue;
            }
            if (--maxRetry < 0) {
                throw new ConnectException("[NACOS HTTP-DELETE] The maximum number of tolerable server reconnection errors has been reached");
            }
            this.serverListMgr.refreshCurrentServerAddr();
        } while (System.currentTimeMillis() <= endTime);
        LOGGER.error("no available server");
        throw new ConnectException("no available server");
    }

    private String getUrl(String serverAddr, String relativePath) {
        String contextPath = this.serverListMgr.getContentPath().startsWith("/") ? this.serverListMgr.getContentPath() : "/" + this.serverListMgr.getContentPath();
        return serverAddr + contextPath + relativePath;
    }

    public static String getAppname() {
        return ParamUtil.getAppName();
    }

    public ServerHttpAgent(ServerListManager mgr) {
        this.serverListMgr = mgr;
    }

    public ServerHttpAgent(ServerListManager mgr, Properties properties) {
        this.serverListMgr = mgr;
        this.init(properties);
    }

    public ServerHttpAgent(Properties properties) throws NacosException {
        this.serverListMgr = new ServerListManager(properties);
        this.securityProxy = new SecurityProxy(properties);
        this.namespaceId = properties.getProperty("namespace");
        this.init(properties);
        this.securityProxy.login(this.serverListMgr.getServerUrls());
        this.executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.alibaba.nacos.client.config.security.updater");
                t.setDaemon(true);
                return t;
            }
        });
        this.executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ServerHttpAgent.this.securityProxy.login(ServerHttpAgent.this.serverListMgr.getServerUrls());
            }
        }, 0L, this.securityInfoRefreshIntervalMills, TimeUnit.MILLISECONDS);
    }

    private void injectSecurityInfo(List<String> params) {
        if (StringUtils.isNotBlank((String)this.securityProxy.getAccessToken())) {
            params.add("accessToken");
            params.add(this.securityProxy.getAccessToken());
        }
        if (StringUtils.isNotBlank((String)this.namespaceId) && !params.contains("tenant")) {
            params.add("tenant");
            params.add(this.namespaceId);
        }
    }

    private void init(Properties properties) {
        this.initEncode(properties);
        this.initAkSk(properties);
        this.initMaxRetry(properties);
    }

    private void initEncode(Properties properties) {
        this.encode = TemplateUtils.stringEmptyAndThenExecute(properties.getProperty("encode"), new Callable<String>(){

            @Override
            public String call() throws Exception {
                return "UTF-8";
            }
        });
    }

    private void initAkSk(Properties properties) {
        String ak;
        String ramRoleName = properties.getProperty("ramRoleName");
        if (!StringUtils.isBlank((String)ramRoleName)) {
            StsConfig.getInstance().setRamRoleName(ramRoleName);
        }
        this.accessKey = StringUtils.isBlank((String)(ak = properties.getProperty("accessKey"))) ? SpasAdapter.getAk() : ak;
        String sk = properties.getProperty("secretKey");
        this.secretKey = StringUtils.isBlank((String)sk) ? SpasAdapter.getSk() : sk;
    }

    private void initMaxRetry(Properties properties) {
        this.maxRetry = ConvertUtils.toInt((String)String.valueOf(properties.get("maxRetry")), (int)3);
    }

    @Override
    public void start() throws NacosException {
        this.serverListMgr.start();
    }

    private List<String> getSpasHeaders(List<String> paramValues) throws IOException {
        ArrayList<String> newHeaders = new ArrayList<String>();
        if (StsConfig.getInstance().isStsOn()) {
            StsCredential stsCredential = this.getStsCredential();
            this.accessKey = stsCredential.accessKeyId;
            this.secretKey = stsCredential.accessKeySecret;
            newHeaders.add("Spas-SecurityToken");
            newHeaders.add(stsCredential.securityToken);
        }
        if (StringUtils.isNotEmpty((String)this.accessKey) && StringUtils.isNotEmpty((String)this.secretKey)) {
            newHeaders.add("Spas-AccessKey");
            newHeaders.add(this.accessKey);
            List<String> signHeaders = SpasAdapter.getSignHeaders(paramValues, this.secretKey);
            if (signHeaders != null) {
                newHeaders.addAll(signHeaders);
            }
        }
        return newHeaders;
    }

    private StsCredential getStsCredential() throws IOException {
        StsCredential stsCredentialTmp;
        boolean cacheSecurityCredentials = StsConfig.getInstance().isCacheSecurityCredentials();
        if (cacheSecurityCredentials && this.stsCredential != null) {
            int timeToRefreshInMillisecond;
            long currentTime = System.currentTimeMillis();
            long expirationTime = this.stsCredential.expiration.getTime();
            if (expirationTime - currentTime > (long)(timeToRefreshInMillisecond = StsConfig.getInstance().getTimeToRefreshInMillisecond())) {
                return this.stsCredential;
            }
        }
        String stsResponse = ServerHttpAgent.getStsResponse();
        this.stsCredential = stsCredentialTmp = (StsCredential)JacksonUtils.toObj((String)stsResponse, (TypeReference)new TypeReference<StsCredential>(){});
        LOGGER.info("[getSTSCredential] code:{}, accessKeyId:{}, lastUpdated:{}, expiration:{}", new Object[]{this.stsCredential.getCode(), this.stsCredential.getAccessKeyId(), this.stsCredential.getLastUpdated(), this.stsCredential.getExpiration()});
        return this.stsCredential;
    }

    private static String getStsResponse() throws IOException {
        String response;
        int respCode;
        String securityCredentials = StsConfig.getInstance().getSecurityCredentials();
        if (securityCredentials != null) {
            return securityCredentials;
        }
        String securityCredentialsUrl = StsConfig.getInstance().getSecurityCredentialsUrl();
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(securityCredentialsUrl).openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(ParamUtil.getConnectTimeout() > 100 ? ParamUtil.getConnectTimeout() : 100);
            conn.setReadTimeout(1000);
            conn.connect();
            respCode = conn.getResponseCode();
            response = 200 == respCode ? IoUtils.toString((InputStream)conn.getInputStream(), (String)"UTF-8") : IoUtils.toString((InputStream)conn.getErrorStream(), (String)"UTF-8");
        }
        catch (IOException e) {
            try {
                LOGGER.error("can not get security credentials", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(conn);
                throw throwable;
            }
        }
        IoUtils.closeQuietly((HttpURLConnection)conn);
        if (200 == respCode) {
            return response;
        }
        LOGGER.error("can not get security credentials, securityCredentialsUrl: {}, responseCode: {}, response: {}", new Object[]{securityCredentialsUrl, respCode, response});
        throw new IOException("can not get security credentials, responseCode: " + respCode + ", response: " + response);
    }

    @Override
    public String getName() {
        return this.serverListMgr.getName();
    }

    @Override
    public String getNamespace() {
        return this.serverListMgr.getNamespace();
    }

    @Override
    public String getTenant() {
        return this.serverListMgr.getTenant();
    }

    @Override
    public String getEncode() {
        return this.encode;
    }

    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LOGGER.info("{} do shutdown begin", (Object)className);
        ThreadUtils.shutdownThreadPool((ExecutorService)this.executorService, (Logger)LOGGER);
        LOGGER.info("{} do shutdown stop", (Object)className);
    }

    private static class StsCredential {
        @JsonProperty(value="AccessKeyId")
        private String accessKeyId;
        @JsonProperty(value="AccessKeySecret")
        private String accessKeySecret;
        @JsonProperty(value="Expiration")
        private Date expiration;
        @JsonProperty(value="SecurityToken")
        private String securityToken;
        @JsonProperty(value="LastUpdated")
        private Date lastUpdated;
        @JsonProperty(value="Code")
        private String code;

        private StsCredential() {
        }

        public String getAccessKeyId() {
            return this.accessKeyId;
        }

        public Date getExpiration() {
            return this.expiration;
        }

        public Date getLastUpdated() {
            return this.lastUpdated;
        }

        public String getCode() {
            return this.code;
        }

        public String toString() {
            return "STSCredential{accessKeyId='" + this.accessKeyId + '\'' + ", accessKeySecret='" + this.accessKeySecret + '\'' + ", expiration=" + this.expiration + ", securityToken='" + this.securityToken + '\'' + ", lastUpdated=" + this.lastUpdated + ", code='" + this.code + '\'' + '}';
        }
    }
}

