/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.logging;

import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Properties;

public class NacosLoggingProperties {
    private static final String NACOS_LOGGING_CONFIG_PROPERTY = "nacos.logging.config";
    private static final String NACOS_LOGGING_DEFAULT_CONFIG_ENABLED_PROPERTY = "nacos.logging.default.config.enabled";
    private static final String NACOS_LOGGING_RELOAD_INTERVAL_PROPERTY = "nacos.logging.reload.interval.seconds";
    private static final long DEFAULT_NACOS_LOGGING_RELOAD_INTERVAL = 10L;
    private final String defaultLocation;
    private final Properties properties;

    public NacosLoggingProperties(String defaultLocation, Properties properties) {
        this.defaultLocation = defaultLocation;
        this.properties = null == properties ? new Properties() : properties;
    }

    public String getLocation() {
        String location = this.properties.getProperty(NACOS_LOGGING_CONFIG_PROPERTY);
        if (StringUtils.isBlank(location)) {
            if (this.isDefaultLocationEnabled()) {
                return this.defaultLocation;
            }
            return null;
        }
        return location;
    }

    private boolean isDefaultLocationEnabled() {
        String property = this.properties.getProperty(NACOS_LOGGING_DEFAULT_CONFIG_ENABLED_PROPERTY);
        return property == null || ConvertUtils.toBoolean(property);
    }

    public long getReloadInternal() {
        String interval = this.properties.getProperty(NACOS_LOGGING_RELOAD_INTERVAL_PROPERTY);
        return ConvertUtils.toLong(interval, 10L);
    }

    public String getValue(String source, String defaultValue) {
        return this.properties.getProperty(source, defaultValue);
    }
}

