/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http;

import com.alibaba.nacos.common.http.BaseHttpMethod;
import com.alibaba.nacos.common.http.Callback;
import com.alibaba.nacos.common.http.handler.ResponseHandler;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.model.RestResult;
import java.lang.reflect.Type;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.util.EntityUtils;

public abstract class BaseHttpClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> RestResult<T> execute(CloseableHttpClient httpClient, Type type, HttpUriRequest request) throws Exception {
        CloseableHttpResponse response = httpClient.execute(request);
        try {
            RestResult data;
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            RestResult restResult = data = (RestResult)ResponseHandler.convert(body, type);
            return restResult;
        }
        finally {
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        }
    }

    protected <T> void execute(CloseableHttpAsyncClient httpAsyncClient, final Type type, final Callback<T> callback, HttpUriRequest request) {
        if (!httpAsyncClient.isRunning()) {
            throw new IllegalArgumentException("httpAsyncClient already shutdown");
        }
        httpAsyncClient.execute(request, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse response) {
                try {
                    String body = EntityUtils.toString((HttpEntity)response.getEntity());
                    RestResult data = (RestResult)ResponseHandler.convert(body, type);
                    data.setCode(response.getStatusLine().getStatusCode());
                    callback.onReceive(data);
                }
                catch (Throwable e) {
                    callback.onError(e);
                }
            }

            public void failed(Exception ex) {
                callback.onError(ex);
            }

            public void cancelled() {
            }
        });
    }

    protected String buildUrl(String baseUrl, Query query) {
        if (query.isEmpty()) {
            return baseUrl;
        }
        return baseUrl + "?" + query.toQueryUrl();
    }

    protected HttpRequestBase build(String url, Header header, String method) throws Exception {
        return this.build(url, header, null, method);
    }

    protected HttpRequestBase build(String url, Header header, Object body, String method) throws Exception {
        BaseHttpMethod httpMethod = BaseHttpMethod.sourceOf(method);
        httpMethod.init(url);
        httpMethod.initHeader(header);
        httpMethod.initEntity(body, header.getValue("Content-Type"));
        return httpMethod.getRequestBase();
    }

    private Header convertHeader(org.apache.http.Header[] headers) {
        Header nHeader = Header.newInstance();
        for (org.apache.http.Header header : headers) {
            nHeader.addParam(header.getName(), header.getValue());
        }
        return nHeader;
    }

    public static class HttpGetWithEntity
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "GET";

        public HttpGetWithEntity(String url) {
            this.setURI(URI.create(url));
        }

        public String getMethod() {
            return METHOD_NAME;
        }
    }
}

