/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http;

public class HttpClientConfig {
    private final int conTimeOutMillis;
    private final int readTimeOutMillis;
    private final int maxRedirects;

    public HttpClientConfig(int conTimeOutMillis, int readTimeOutMillis, int maxRedirects) {
        this.conTimeOutMillis = conTimeOutMillis;
        this.readTimeOutMillis = readTimeOutMillis;
        this.maxRedirects = maxRedirects;
    }

    public int getConTimeOutMillis() {
        return this.conTimeOutMillis;
    }

    public int getReadTimeOutMillis() {
        return this.readTimeOutMillis;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public static HttpClientConfigBuilder builder() {
        return new HttpClientConfigBuilder();
    }

    public static final class HttpClientConfigBuilder {
        private int conTimeOutMillis = -1;
        private int readTimeOutMillis = -1;
        private int maxRedirects = 50;

        public HttpClientConfigBuilder setConTimeOutMillis(int conTimeOutMillis) {
            this.conTimeOutMillis = conTimeOutMillis;
            return this;
        }

        public HttpClientConfigBuilder setReadTimeOutMillis(int readTimeOutMillis) {
            this.readTimeOutMillis = readTimeOutMillis;
            return this;
        }

        public HttpClientConfigBuilder setMaxRedirects(int maxRedirects) {
            this.maxRedirects = maxRedirects;
            return this;
        }

        public HttpClientConfig build() {
            return new HttpClientConfig(this.conTimeOutMillis, this.readTimeOutMillis, this.maxRedirects);
        }
    }
}

