/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.PayloadRegistry;
import com.alibaba.nacos.api.remote.RequestCallBack;
import com.alibaba.nacos.api.remote.RequestFuture;
import com.alibaba.nacos.api.remote.request.ConnectResetRequest;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.ConnectResetResponse;
import com.alibaba.nacos.api.remote.response.ConnectionUnregisterResponse;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.client.Connection;
import com.alibaba.nacos.common.remote.client.ConnectionEventListener;
import com.alibaba.nacos.common.remote.client.RpcClientStatus;
import com.alibaba.nacos.common.remote.client.ServerListFactory;
import com.alibaba.nacos.common.remote.client.ServerRequestHandler;
import com.alibaba.nacos.common.utils.LoggerUtils;
import com.alibaba.nacos.common.utils.NumberUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcClient
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcClient.class);
    private ServerListFactory serverListFactory;
    protected LinkedBlockingQueue<ConnectionEvent> eventLinkedBlockingQueue = new LinkedBlockingQueue();
    protected volatile AtomicReference<RpcClientStatus> rpcClientStatus = new AtomicReference<RpcClientStatus>(RpcClientStatus.WAIT_INIT);
    protected ScheduledExecutorService executorService;
    protected volatile Connection currentConnetion;
    protected Map<String, String> labels = new HashMap<String, String>();
    private String name;
    protected List<ConnectionEventListener> connectionEventListeners = new ArrayList<ConnectionEventListener>();
    protected List<ServerRequestHandler> serverRequestHandlers = new ArrayList<ServerRequestHandler>();
    private final ReentrantLock switchingLock = new ReentrantLock();
    private volatile AtomicBoolean switchingFlag = new AtomicBoolean(false);

    public RpcClient(String name) {
        this.name = name;
    }

    protected RequestMeta buildMeta() {
        RequestMeta meta = new RequestMeta();
        meta.setClientVersion(VersionUtils.getFullClientVersion());
        meta.setLabels(this.labels);
        return meta;
    }

    public RpcClient(ServerListFactory serverListFactory) {
        this.serverListFactory = serverListFactory;
        this.rpcClientStatus.compareAndSet(RpcClientStatus.WAIT_INIT, RpcClientStatus.INITED);
        LoggerUtils.printIfInfoEnabled(LOGGER, "RpcClient init in constructor , ServerListFactory ={}", serverListFactory.getClass().getName());
    }

    public RpcClient(String name, ServerListFactory serverListFactory) {
        this(name);
        this.serverListFactory = serverListFactory;
        this.rpcClientStatus.compareAndSet(RpcClientStatus.WAIT_INIT, RpcClientStatus.INITED);
        LoggerUtils.printIfInfoEnabled(LOGGER, "RpcClient init in constructor , ServerListFactory ={}", serverListFactory.getClass().getName());
    }

    protected void notifyDisConnected() {
        if (!this.connectionEventListeners.isEmpty()) {
            LoggerUtils.printIfInfoEnabled(LOGGER, "Notify connection event listeners.", new Object[0]);
            for (ConnectionEventListener connectionEventListener : this.connectionEventListeners) {
                connectionEventListener.onDisConnect();
            }
        }
    }

    protected void notifyConnected() {
        if (!this.connectionEventListeners.isEmpty()) {
            for (ConnectionEventListener connectionEventListener : this.connectionEventListeners) {
                connectionEventListener.onConnected();
            }
        }
    }

    public boolean isWaitInited() {
        return this.rpcClientStatus.get() == RpcClientStatus.WAIT_INIT;
    }

    public boolean isRunning() {
        return this.rpcClientStatus.get() == RpcClientStatus.RUNNING;
    }

    public boolean isShutdwon() {
        return this.rpcClientStatus.get() == RpcClientStatus.SHUTDOWN;
    }

    public void init(ServerListFactory serverListFactory) {
        if (!this.isWaitInited()) {
            return;
        }
        this.serverListFactory = serverListFactory;
        this.rpcClientStatus.compareAndSet(RpcClientStatus.WAIT_INIT, RpcClientStatus.INITED);
        LoggerUtils.printIfInfoEnabled(LOGGER, "RpcClient init , ServerListFactory ={}", serverListFactory.getClass().getName());
    }

    public void initLabels(Map<String, String> labels) {
        this.labels.putAll(labels);
        LoggerUtils.printIfInfoEnabled(LOGGER, "RpcClient init label  ,labels={}", this.labels);
    }

    public final void start() throws NacosException {
        boolean success = this.rpcClientStatus.compareAndSet(RpcClientStatus.INITED, RpcClientStatus.STARTING);
        if (!success) {
            return;
        }
        this.executorService = new ScheduledThreadPoolExecutor(5, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.alibaba.nacos.client.remote.worker");
                t.setDaemon(true);
                return t;
            }
        });
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    ConnectionEvent take = null;
                    try {
                        take = RpcClient.this.eventLinkedBlockingQueue.take();
                        if (take.isConnected()) {
                            RpcClient.this.notifyConnected();
                            continue;
                        }
                        if (!take.isDisConnected()) continue;
                        RpcClient.this.notifyDisConnected();
                    }
                    catch (Exception exception) {
                    }
                }
            }
        });
        Connection connectToServer = null;
        this.rpcClientStatus.set(RpcClientStatus.STARTING);
        int startUpretyTimes = 3;
        while (startUpretyTimes > 0 && connectToServer == null) {
            try {
                --startUpretyTimes;
                ServerInfo serverInfo = this.nextRpcServer();
                LoggerUtils.printIfInfoEnabled(LOGGER, String.format("[%s]try to  connect to server on start up,server : %s", this.name, serverInfo), new Object[0]);
                connectToServer = this.connectToServer(serverInfo);
            }
            catch (Exception e) {
                LoggerUtils.printIfWarnEnabled(LOGGER, String.format("fail to connect to server on start up,error message=%s,start up trytimes left :%s", e.getMessage(), startUpretyTimes), new Object[0]);
            }
        }
        if (connectToServer != null) {
            LoggerUtils.printIfInfoEnabled(LOGGER, String.format("[%s]success to connect to server on start up", this.name), new Object[0]);
            this.currentConnetion = connectToServer;
            this.rpcClientStatus.set(RpcClientStatus.RUNNING);
            this.eventLinkedBlockingQueue.offer(new ConnectionEvent(1));
        } else {
            this.switchServerAsync();
        }
        this.registerServerPushResponseHandler(new ServerRequestHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Response requestReply(Request request, RequestMeta requestMeta) {
                if (request instanceof ConnectResetRequest) {
                    try {
                        3 var3_3 = this;
                        synchronized (var3_3) {
                            if (RpcClient.this.isRunning()) {
                                ConnectResetRequest connectResetRequest = (ConnectResetRequest)request;
                                if (StringUtils.isNotBlank(connectResetRequest.getServerIp()) && NumberUtil.isDigits(connectResetRequest.getServerPort())) {
                                    ServerInfo serverInfo = new ServerInfo();
                                    serverInfo.setServerIp(connectResetRequest.getServerIp());
                                    serverInfo.setServerPort(Integer.valueOf(connectResetRequest.getServerPort()) + RpcClient.this.rpcPortOffset());
                                    RpcClient.this.switchServerAsync(serverInfo);
                                } else {
                                    RpcClient.this.switchServerAsync();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        LoggerUtils.printIfErrorEnabled(LOGGER, "switch server  error ", e);
                    }
                    return new ConnectResetResponse();
                }
                return null;
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    RpcClient.this.shutdown();
                }
                catch (NacosException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void shutdown() throws NacosException {
        this.executorService.shutdown();
        this.rpcClientStatus.set(RpcClientStatus.SHUTDOWN);
        this.closeConnection(this.currentConnetion);
    }

    public void switchServerAsync() {
        this.switchServerAsync(null);
    }

    protected void switchServerAsync(final ServerInfo recommendServerInfo) {
        if (this.switchingFlag.get()) {
            return;
        }
        this.executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AtomicReference<ServerInfo> recommendServer = new AtomicReference<ServerInfo>(recommendServerInfo);
                    boolean innerLock = RpcClient.this.switchingLock.tryLock();
                    if (!innerLock) {
                        return;
                    }
                    RpcClient.this.switchingFlag.compareAndSet(false, true);
                    boolean switchSuccess = false;
                    int reConnectTimes = 0;
                    int retryTurns = 0;
                    Exception lastException = null;
                    while (!switchSuccess && !RpcClient.this.isShutdwon()) {
                        ServerInfo serverInfo = null;
                        try {
                            serverInfo = recommendServer.get() == null ? RpcClient.this.nextRpcServer() : recommendServer.get();
                            Connection connectNew = RpcClient.this.connectToServer(serverInfo);
                            if (connectNew != null) {
                                LoggerUtils.printIfInfoEnabled(LOGGER, String.format("[%s]-success to connect server : %s", RpcClient.this.name, serverInfo), new Object[0]);
                                if (RpcClient.this.currentConnetion != null) {
                                    RpcClient.this.currentConnetion.setAbandon(true);
                                    RpcClient.this.closeConnection(RpcClient.this.currentConnetion);
                                }
                                RpcClient.this.currentConnetion = connectNew;
                                RpcClient.this.rpcClientStatus.set(RpcClientStatus.RUNNING);
                                switchSuccess = true;
                                boolean s = RpcClient.this.eventLinkedBlockingQueue.add(new ConnectionEvent(1));
                                return;
                            }
                            if (RpcClient.this.isShutdwon()) {
                                RpcClient.this.closeConnection(connectNew);
                            }
                            lastException = null;
                        }
                        catch (Exception e) {
                            lastException = e;
                        }
                        finally {
                            recommendServer.set(null);
                        }
                        if (reConnectTimes > 0 && reConnectTimes % RpcClient.this.serverListFactory.getServerList().size() == 0) {
                            LoggerUtils.printIfInfoEnabled(LOGGER, String.format("[%s]-fail to connect server,after trying %s times, last tryed server is %s", RpcClient.this.name, reConnectTimes, serverInfo), new Object[0]);
                            ++retryTurns;
                        }
                        ++reConnectTimes;
                        try {
                            if (RpcClient.this.isRunning()) continue;
                            Thread.sleep((long)Math.min(retryTurns + 1, 10) * 100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (RpcClient.this.isShutdwon()) {
                        LoggerUtils.printIfInfoEnabled(LOGGER, String.format("[%s]- client is shutdown ,stop reconnect to server", RpcClient.this.name), new Object[0]);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    RpcClient.this.switchingFlag.set(false);
                    RpcClient.this.switchingLock.unlock();
                }
            }
        });
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            connection.close();
            this.eventLinkedBlockingQueue.add(new ConnectionEvent(0));
        }
    }

    public abstract ConnectionType getConnectionType();

    public abstract int rpcPortOffset();

    public ServerInfo getCurrentServer() {
        if (this.currentConnetion != null) {
            return this.currentConnetion.serverInfo;
        }
        return null;
    }

    public Response request(Request request) throws NacosException {
        return this.request(request, 3000L);
    }

    public Response request(Request request, long timeoutMills) throws NacosException {
        Response response = null;
        Exception exceptionToThrow = null;
        for (int retryTimes = 3; retryTimes > 0; --retryTimes) {
            try {
                if (this.currentConnetion == null || !this.isRunning()) {
                    throw new NacosException(-400, "client not connected.");
                }
                response = this.currentConnetion.request(request, this.buildMeta());
                if (response == null) continue;
                if (response instanceof ConnectionUnregisterResponse) {
                    RpcClient rpcClient = this;
                    synchronized (rpcClient) {
                        if (this.rpcClientStatus.compareAndSet(RpcClientStatus.RUNNING, RpcClientStatus.UNHEALTHY)) {
                            this.switchServerAsync();
                        }
                        throw new IllegalStateException("Invalid client status.");
                    }
                }
                return response;
            }
            catch (Exception e) {
                LoggerUtils.printIfErrorEnabled(LOGGER, "Fail to send request,request={},errorMesssage={}", request, e.getMessage());
                exceptionToThrow = e;
            }
        }
        if (this.rpcClientStatus.compareAndSet(RpcClientStatus.RUNNING, RpcClientStatus.UNHEALTHY)) {
            this.switchServerAsync();
        }
        if (exceptionToThrow != null) {
            throw new NacosException(500, exceptionToThrow);
        }
        return null;
    }

    public void asyncRequest(Request request, RequestCallBack callback) throws NacosException {
        Exception exceptionToThrow = null;
        for (int retryTimes = 3; retryTimes > 0; --retryTimes) {
            try {
                if (this.currentConnetion == null) {
                    throw new NacosException(-400, "client not connected.");
                }
                this.currentConnetion.asyncRequest(request, this.buildMeta(), callback);
                return;
            }
            catch (Exception e) {
                LoggerUtils.printIfErrorEnabled(LOGGER, "Fail to send request,request={},errorMesssage={}", request, e.getMessage());
                exceptionToThrow = e;
                continue;
            }
        }
        if (exceptionToThrow != null) {
            throw new NacosException(500, exceptionToThrow);
        }
    }

    public RequestFuture requestFuture(Request request) throws NacosException {
        if (this.currentConnetion == null) {
            throw new NacosException(-400, "client not connected.");
        }
        RequestFuture requestFuture = this.currentConnetion.requestFuture(request, this.buildMeta());
        return requestFuture;
    }

    public abstract Connection connectToServer(ServerInfo var1) throws Exception;

    protected Response handleServerRequest(Request request, RequestMeta meta) {
        for (ServerRequestHandler serverRequestHandler : this.serverRequestHandlers) {
            Response response = serverRequestHandler.requestReply(request, meta);
            if (response == null) continue;
            return response;
        }
        return null;
    }

    public synchronized void registerConnectionListener(ConnectionEventListener connectionEventListener) {
        LoggerUtils.printIfInfoEnabled(LOGGER, "Registry connection listener to current client:{}", connectionEventListener.getClass().getName());
        this.connectionEventListeners.add(connectionEventListener);
    }

    public synchronized void registerServerPushResponseHandler(ServerRequestHandler serverRequestHandler) {
        LoggerUtils.printIfInfoEnabled(LOGGER, " Register server push request  handler :{}", serverRequestHandler.getClass().getName());
        this.serverRequestHandlers.add(serverRequestHandler);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServerListFactory getServerListFactory() {
        return this.serverListFactory;
    }

    protected ServerInfo nextRpcServer() {
        String serverAddress = this.getServerListFactory().genNextServer();
        return this.resolveServerInfo(serverAddress);
    }

    protected ServerInfo currentRpcServer() {
        String serverAddress = this.getServerListFactory().getCurrentServer();
        return this.resolveServerInfo(serverAddress);
    }

    private ServerInfo resolveServerInfo(String serverAddress) {
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.serverPort = this.rpcPortOffset();
        if (serverAddress.contains("http")) {
            serverInfo.serverIp = serverAddress.split(":")[1].replaceAll("//", "");
            serverInfo.serverPort += Integer.valueOf(serverAddress.split(":")[2].replaceAll("//", "")).intValue();
        } else {
            serverInfo.serverIp = serverAddress.split(":")[0];
            serverInfo.serverPort += Integer.valueOf(serverAddress.split(":")[1]).intValue();
        }
        return serverInfo;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    static {
        PayloadRegistry.init();
    }

    public class ConnectionEvent {
        public static final int CONNECTED = 1;
        public static final int DISCONNECTED = 0;
        int eventType;

        public ConnectionEvent(int eventType) {
            this.eventType = eventType;
        }

        public boolean isConnected() {
            return this.eventType == 1;
        }

        public boolean isDisConnected() {
            return this.eventType == 0;
        }
    }

    public static class ServerInfo {
        protected String serverIp;
        protected int serverPort;

        public void setServerIp(String serverIp) {
            this.serverIp = serverIp;
        }

        public void setServerPort(int serverPort) {
            this.serverPort = serverPort;
        }

        public String getServerIp() {
            return this.serverIp;
        }

        public int getServerPort() {
            return this.serverPort;
        }

        public String toString() {
            return "ServerInfo{serverIp='" + this.serverIp + '\'' + ", serverPort=" + this.serverPort + '}';
        }
    }
}

