/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client.grpc;

import com.alibaba.nacos.api.grpc.auto.BiRequestStreamGrpc;
import com.alibaba.nacos.api.grpc.auto.Payload;
import com.alibaba.nacos.api.grpc.auto.RequestGrpc;
import com.alibaba.nacos.api.remote.request.ConnectionSetupRequest;
import com.alibaba.nacos.api.remote.request.PushAckRequest;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.ServerCheckRequest;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.client.Connection;
import com.alibaba.nacos.common.remote.client.RpcClient;
import com.alibaba.nacos.common.remote.client.RpcClientStatus;
import com.alibaba.nacos.common.remote.client.grpc.GrpcConnection;
import com.alibaba.nacos.common.remote.client.grpc.GrpcUtils;
import com.alibaba.nacos.common.utils.LoggerUtils;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GrpcClient
extends RpcClient {
    static final Logger LOGGER = LoggerFactory.getLogger((String)"com.alibaba.nacos.common.remote.client");

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.GRPC;
    }

    public GrpcClient(String name) {
        super(name);
    }

    private RequestGrpc.RequestFutureStub createNewChannelStub(String serverIp, int serverPort) {
        ManagedChannel managedChannelTemp = ManagedChannelBuilder.forAddress((String)serverIp, (int)serverPort).usePlaintext().build();
        RequestGrpc.RequestFutureStub grpcServiceStubTemp = RequestGrpc.newFutureStub((Channel)managedChannelTemp);
        boolean checkSucess = this.serverCheck(grpcServiceStubTemp);
        if (checkSucess) {
            return grpcServiceStubTemp;
        }
        this.shuntDownChannel(managedChannelTemp);
        return null;
    }

    private void shuntDownChannel(ManagedChannel managedChannel) {
        if (managedChannel != null && !managedChannel.isShutdown()) {
            managedChannel.shutdownNow();
        }
    }

    private boolean serverCheck(RequestGrpc.RequestFutureStub requestBlockingStub) {
        try {
            if (requestBlockingStub == null) {
                return false;
            }
            ServerCheckRequest serverCheckRequest = new ServerCheckRequest();
            Payload grpcRequest = GrpcUtils.convert((Request)serverCheckRequest, this.buildMeta());
            ListenableFuture responseFuture = requestBlockingStub.request(grpcRequest);
            Payload response = (Payload)responseFuture.get();
            return response != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private StreamObserver<Payload> bindRequestStream(BiRequestStreamGrpc.BiRequestStreamStub streamStub, final GrpcConnection grpcConn) {
        StreamObserver payloadStreamObserver = streamStub.requestBiStream((StreamObserver)new StreamObserver<Payload>(){

            public void onNext(Payload payload) {
                LoggerUtils.printIfDebugEnabled(LOGGER, " stream server reuqust receive  ,original info :{}", payload.toString());
                try {
                    GrpcUtils.PlainRequest parse = GrpcUtils.parse(payload);
                    Request request = (Request)parse.getBody();
                    if (request != null) {
                        try {
                            Response response = GrpcClient.this.handleServerRequest(request, parse.metadata);
                            response.setRequestId(request.getRequestId());
                            GrpcClient.this.sendResponse(response);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            GrpcClient.this.sendResponse(request.getRequestId(), false);
                        }
                    }
                }
                catch (Exception e) {
                    LoggerUtils.printIfErrorEnabled(LOGGER, "error tp process server push response  :{}", payload.getBody().getValue().toStringUtf8());
                }
            }

            public void onError(Throwable throwable) {
                if (GrpcClient.this.isRunning() && !grpcConn.isAbandon()) {
                    LoggerUtils.printIfErrorEnabled(LOGGER, " Request Stream Error ,switch server ", throwable);
                    if (throwable instanceof StatusRuntimeException) {
                        Status.Code code = ((StatusRuntimeException)throwable).getStatus().getCode();
                        if ((Status.UNAVAILABLE.getCode().equals((Object)code) || Status.CANCELLED.getCode().equals((Object)code)) && GrpcClient.this.rpcClientStatus.compareAndSet(RpcClientStatus.RUNNING, RpcClientStatus.UNHEALTHY)) {
                            GrpcClient.this.switchServerAsync();
                        }
                    }
                } else {
                    LoggerUtils.printIfErrorEnabled(LOGGER, "client is not running status ,ignore error event", new Object[0]);
                }
            }

            public void onCompleted() {
                if (GrpcClient.this.isRunning() && !grpcConn.isAbandon()) {
                    LoggerUtils.printIfErrorEnabled(LOGGER, " Request Stream onCompleted ,switch server ", new Object[0]);
                    if (GrpcClient.this.rpcClientStatus.compareAndSet(RpcClientStatus.RUNNING, RpcClientStatus.UNHEALTHY)) {
                        GrpcClient.this.switchServerAsync();
                    }
                } else {
                    LoggerUtils.printIfErrorEnabled(LOGGER, "client is not running status ,ignore complete  event ", new Object[0]);
                }
            }
        });
        return payloadStreamObserver;
    }

    private void sendResponse(String ackId, boolean success) {
        try {
            PushAckRequest request = PushAckRequest.build((String)ackId, (boolean)success);
            this.currentConnetion.request((Request)request, this.buildMeta());
        }
        catch (Exception e) {
            LOGGER.error("error to send ack  response,ackId->:{}", (Object)ackId);
        }
    }

    private void sendResponse(Response response) {
        try {
            ((GrpcConnection)this.currentConnetion).sendResponse(response);
        }
        catch (Exception e) {
            LOGGER.error("error to send ack  response,ackId->:{}", (Object)response.getRequestId());
        }
    }

    @Override
    public Connection connectToServer(RpcClient.ServerInfo serverInfo) {
        try {
            RequestGrpc.RequestFutureStub newChannelStubTemp = this.createNewChannelStub(serverInfo.getServerIp(), serverInfo.getServerPort());
            if (newChannelStubTemp != null) {
                BiRequestStreamGrpc.BiRequestStreamStub biRequestStreamStub = BiRequestStreamGrpc.newStub((Channel)newChannelStubTemp.getChannel());
                GrpcConnection grpcConn = new GrpcConnection(serverInfo);
                StreamObserver<Payload> payloadStreamObserver = this.bindRequestStream(biRequestStreamStub, grpcConn);
                grpcConn.setPayloadStreamObserver(payloadStreamObserver);
                grpcConn.setGrpcFutureServiceStub(newChannelStubTemp);
                grpcConn.setChannel((ManagedChannel)newChannelStubTemp.getChannel());
                ConnectionSetupRequest conconSetupRequest = new ConnectionSetupRequest();
                grpcConn.sendRequest((Request)conconSetupRequest, this.buildMeta());
                return grpcConn;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("fail to connect to server  ! ", (Throwable)e);
            return null;
        }
    }
}

