/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client.grpc;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.grpc.auto.Payload;
import com.alibaba.nacos.api.grpc.auto.RequestGrpc;
import com.alibaba.nacos.api.remote.RequestCallBack;
import com.alibaba.nacos.api.remote.RequestFuture;
import com.alibaba.nacos.api.remote.RpcScheduledExecutor;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.api.remote.response.ResponseCode;
import com.alibaba.nacos.common.remote.client.Connection;
import com.alibaba.nacos.common.remote.client.RpcClient;
import com.alibaba.nacos.common.remote.client.grpc.GrpcUtils;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class GrpcConnection
extends Connection {
    protected ManagedChannel channel;
    protected RequestGrpc.RequestFutureStub grpcFutureServiceStub;
    protected StreamObserver<Payload> payloadStreamObserver;

    public GrpcConnection(RpcClient.ServerInfo serverInfo) {
        super(serverInfo);
    }

    public Response request(Request request, RequestMeta requestMeta) throws NacosException {
        return this.request(request, requestMeta, 3000L);
    }

    public Response request(Request request, RequestMeta requestMeta, long timeouts) throws NacosException {
        Payload grpcRequest = GrpcUtils.convert(request, requestMeta);
        ListenableFuture requestFuture = this.grpcFutureServiceStub.request(grpcRequest);
        Payload grpcResponse = null;
        try {
            grpcResponse = (Payload)requestFuture.get(timeouts, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw new NacosException(500, (Throwable)e);
        }
        Response response = (Response)GrpcUtils.parse(grpcResponse).getBody();
        return response;
    }

    public RequestFuture requestFuture(Request request, RequestMeta requestMeta) throws NacosException {
        Payload grpcRequest = GrpcUtils.convert(request, requestMeta);
        final ListenableFuture requestFuture = this.grpcFutureServiceStub.request(grpcRequest);
        return new RequestFuture(){

            public boolean isDone() {
                return requestFuture.isDone();
            }

            public Response get() throws InterruptedException, ExecutionException {
                Payload grpcResponse = null;
                grpcResponse = (Payload)requestFuture.get();
                Response response = (Response)GrpcUtils.parse(grpcResponse).getBody();
                return response;
            }

            public Response get(long timeout) throws TimeoutException, InterruptedException, ExecutionException {
                Payload grpcResponse = null;
                try {
                    grpcResponse = (Payload)requestFuture.get(timeout, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    throw e;
                }
                catch (ExecutionException e) {
                    throw e;
                }
                Response response = (Response)GrpcUtils.parse(grpcResponse).getBody();
                return response;
            }
        };
    }

    public void sendResponse(Response response) {
        Payload convert = GrpcUtils.convert(response);
        this.payloadStreamObserver.onNext((Object)convert);
    }

    public void sendRequest(Request request, RequestMeta meta) {
        Payload convert = GrpcUtils.convert(request, meta);
        this.payloadStreamObserver.onNext((Object)convert);
    }

    public void asyncRequest(Request request, RequestMeta requestMeta, final RequestCallBack requestCallBack) throws NacosException {
        Payload grpcRequest = GrpcUtils.convert(request, requestMeta);
        ListenableFuture requestFuture = this.grpcFutureServiceStub.request(grpcRequest);
        Futures.addCallback((ListenableFuture)requestFuture, (FutureCallback)new FutureCallback<Payload>(){

            public void onSuccess(@NullableDecl Payload grpcResponse) {
                Response response = (Response)GrpcUtils.parse(grpcResponse).getBody();
                if (response != null && response.isSuccess()) {
                    requestCallBack.onResponse(response);
                } else {
                    requestCallBack.onException((Throwable)new NacosException(response == null ? ResponseCode.FAIL.getCode() : response.getErrorCode(), response == null ? "null" : response.getMessage()));
                }
            }

            public void onFailure(Throwable throwable) {
                if (throwable instanceof CancellationException) {
                    requestCallBack.onException((Throwable)new TimeoutException("Timeout after " + requestCallBack.getTimeout() + " millseconds."));
                } else {
                    requestCallBack.onException(throwable);
                }
            }
        }, (Executor)RpcScheduledExecutor.AYNS_REQUEST_EXECUTOR);
        ListenableFuture payloadListenableFuture = Futures.withTimeout((ListenableFuture)requestFuture, (long)requestCallBack.getTimeout(), (TimeUnit)TimeUnit.MILLISECONDS, (ScheduledExecutorService)RpcScheduledExecutor.TIMEOUT_SHEDULER);
    }

    public void close() {
        if (this.payloadStreamObserver != null) {
            this.payloadStreamObserver.onCompleted();
        }
        if (this.channel != null && !this.channel.isShutdown()) {
            this.channel.shutdownNow();
        }
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public void setChannel(ManagedChannel channel) {
        this.channel = channel;
    }

    public RequestGrpc.RequestFutureStub getGrpcFutureServiceStub() {
        return this.grpcFutureServiceStub;
    }

    public void setGrpcFutureServiceStub(RequestGrpc.RequestFutureStub grpcFutureServiceStub) {
        this.grpcFutureServiceStub = grpcFutureServiceStub;
    }

    public StreamObserver<Payload> getPayloadStreamObserver() {
        return this.payloadStreamObserver;
    }

    public void setPayloadStreamObserver(StreamObserver<Payload> payloadStreamObserver) {
        this.payloadStreamObserver = payloadStreamObserver;
    }
}

