/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client.grpc;

import com.alibaba.nacos.api.exception.runtime.NacosDeserializationException;
import com.alibaba.nacos.api.exception.runtime.NacosSerializationException;
import com.alibaba.nacos.api.grpc.auto.Metadata;
import com.alibaba.nacos.api.grpc.auto.Payload;
import com.alibaba.nacos.api.remote.PayloadRegistry;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.common.utils.VersionUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import java.io.IOException;

public class GrpcUtils {
    static ObjectMapper mapper = new ObjectMapper();

    private static String toJson(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new NacosSerializationException(obj.getClass(), (Throwable)e);
        }
    }

    public static <T> T toObj(String json, Class<T> cls) {
        try {
            return (T)mapper.readValue(json, cls);
        }
        catch (IOException e) {
            throw new NacosDeserializationException(cls, (Throwable)e);
        }
    }

    public static Payload convert(Request request, RequestMeta meta) {
        Payload.Builder builder = Payload.newBuilder();
        Metadata.Builder metaBuilder = Metadata.newBuilder();
        if (meta != null) {
            metaBuilder.setClientIp(meta.getClientIp()).setClientPort(meta.getClientPort()).setConnectionId(meta.getConnectionId()).putAllLabels(meta.getLabels()).putAllHeaders(request.getHeaders()).setClientVersion(meta.getClientVersion()).setType(request.getClass().getName());
        }
        builder.setMetadata(metaBuilder.build());
        request.clearHeaders();
        String jsonString = GrpcUtils.toJson(request);
        Payload payload = builder.setBody(Any.newBuilder().setValue(ByteString.copyFromUtf8((String)jsonString))).build();
        return payload;
    }

    public static Payload convert(Request request, Metadata meta) {
        Metadata buildMeta = meta.toBuilder().putAllHeaders(request.getHeaders()).build();
        request.clearHeaders();
        String jsonString = GrpcUtils.toJson(request);
        Payload.Builder builder = Payload.newBuilder();
        Payload payload = builder.setBody(Any.newBuilder().setValue(ByteString.copyFromUtf8((String)jsonString))).setMetadata(buildMeta).build();
        return payload;
    }

    public static Payload convert(Response response) {
        String jsonString = GrpcUtils.toJson(response);
        Metadata.Builder metaBuilder = Metadata.newBuilder();
        metaBuilder.setClientVersion(VersionUtils.getFullClientVersion()).setType(response.getClass().getName());
        Payload payload = Payload.newBuilder().setBody(Any.newBuilder().setValue(ByteString.copyFromUtf8((String)jsonString))).setMetadata(metaBuilder.build()).build();
        return payload;
    }

    public static PlainRequest parse(Payload payload) {
        PlainRequest plainRequest = new PlainRequest();
        Class classbyType = PayloadRegistry.getClassbyType((String)payload.getMetadata().getType());
        if (classbyType != null) {
            Object obj = GrpcUtils.toObj(payload.getBody().getValue().toStringUtf8(), classbyType);
            if (obj instanceof Request) {
                ((Request)obj).putAllHeader(payload.getMetadata().getHeadersMap());
            }
            plainRequest.body = obj;
        }
        plainRequest.type = payload.getMetadata().getType();
        plainRequest.metadata = GrpcUtils.convertMeta(payload.getMetadata());
        return plainRequest;
    }

    private static RequestMeta convertMeta(Metadata metadata) {
        RequestMeta requestMeta = new RequestMeta();
        requestMeta.setClientIp(metadata.getClientIp());
        requestMeta.setClientPort(metadata.getClientPort());
        requestMeta.setConnectionId(metadata.getConnectionId());
        requestMeta.setClientVersion(metadata.getClientVersion());
        requestMeta.setLabels(metadata.getLabelsMap());
        return requestMeta;
    }

    static {
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static class PlainRequest {
        String type;
        Object body;
        RequestMeta metadata;

        public RequestMeta getMetadata() {
            return this.metadata;
        }

        public void setMetadata(RequestMeta metadata) {
            this.metadata = metadata;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Object getBody() {
            return this.body;
        }

        public void setBody(Object body) {
            this.body = body;
        }
    }
}

