/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client.rsocket;

import com.alibaba.nacos.api.exception.runtime.NacosDeserializationException;
import com.alibaba.nacos.api.exception.runtime.NacosSerializationException;
import com.alibaba.nacos.api.remote.PayloadRegistry;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.Response;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import io.rsocket.Payload;
import io.rsocket.util.DefaultPayload;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;

public class RsocketUtils {
    static ObjectMapper mapper = new ObjectMapper();

    private static String toJson(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new NacosSerializationException(obj.getClass(), (Throwable)e);
        }
    }

    public static <T> T toObj(String json, Class<T> cls) {
        try {
            return (T)mapper.readValue(json, cls);
        }
        catch (IOException e) {
            throw new NacosDeserializationException(cls, (Throwable)e);
        }
    }

    public static JsonNode toObj(String json) {
        try {
            return mapper.readTree(json);
        }
        catch (IOException e) {
            throw new NacosDeserializationException((Throwable)e);
        }
    }

    public static Payload convertRequestToPayload(Request request, RequestMeta meta) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("clientPort", (Number)meta.getClientPort());
        jsonObject.addProperty("connectionId", meta.getConnectionId());
        jsonObject.addProperty("clientIp", meta.getClientIp());
        jsonObject.addProperty("clientVersion", meta.getClientVersion());
        jsonObject.addProperty("labels", RsocketUtils.toJson(meta.getLabels()));
        jsonObject.addProperty("headers", RsocketUtils.toJson(request.getHeaders()));
        jsonObject.addProperty("type", request.getClass().getName());
        request.clearHeaders();
        return DefaultPayload.create((byte[])RsocketUtils.toJson(request).getBytes(), (byte[])jsonObject.toString().getBytes());
    }

    public static Payload convertResponseToPayload(Response response) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", response.getClass().getName());
        return DefaultPayload.create((byte[])RsocketUtils.toJson(response).getBytes(), (byte[])jsonObject.toString().getBytes());
    }

    public static Response parseResponseFromPayload(Payload payload) {
        String metaString = payload.getMetadataUtf8();
        JsonNode metaJsonNode = RsocketUtils.toObj(metaString);
        String type = metaJsonNode.get("type").textValue();
        String bodyString = RsocketUtils.getPayloadString(payload);
        Class classbyType = PayloadRegistry.getClassbyType((String)type);
        PlainRequest plainRequest = new PlainRequest();
        plainRequest.setType(type);
        Response response = (Response)RsocketUtils.toObj(bodyString, classbyType);
        return response;
    }

    public static PlainRequest parsePlainRequestFromPayload(Payload payload) {
        String metaString = payload.getMetadataUtf8();
        JsonNode metaJsonNode = RsocketUtils.toObj(metaString);
        String type = metaJsonNode.get("type").textValue();
        Map labels = RsocketUtils.toObj(metaJsonNode.get("labels").textValue(), Map.class);
        RequestMeta requestMeta = new RequestMeta();
        requestMeta.setClientVersion(metaJsonNode.has("clientVersion") ? metaJsonNode.get("clientVersion").textValue() : "");
        requestMeta.setConnectionId(metaJsonNode.has("connectionId") ? metaJsonNode.get("connectionId").textValue() : "");
        requestMeta.setClientPort(metaJsonNode.has("clientPort") ? metaJsonNode.get("clientPort").intValue() : 0);
        requestMeta.setClientIp(metaJsonNode.has("clientIp") ? metaJsonNode.get("clientIp").textValue() : "");
        requestMeta.setLabels(labels);
        String bodyString = RsocketUtils.getPayloadString(payload);
        Class classbyType = PayloadRegistry.getClassbyType((String)type);
        PlainRequest plainRequest = new PlainRequest();
        plainRequest.setType(type);
        Request request = (Request)RsocketUtils.toObj(bodyString, classbyType);
        Map headers = RsocketUtils.toObj(metaJsonNode.get("headers").textValue(), Map.class);
        request.putAllHeader(headers);
        plainRequest.setBody(request);
        plainRequest.setMetadata(requestMeta);
        return plainRequest;
    }

    private static String getPayloadString(Payload payload) {
        ByteBuffer data1 = payload.getData();
        byte[] data = new byte[data1.remaining()];
        payload.data().readBytes(data);
        byte[] bytes = new byte[]{};
        return new String(bytes);
    }

    static {
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static class PlainRequest {
        String type;
        Request body;
        RequestMeta metadata;

        public String toString() {
            return "PlainRequest{type='" + this.type + '\'' + ", body=" + this.body + ", metadata=" + this.metadata + '}';
        }

        public RequestMeta getMetadata() {
            return this.metadata;
        }

        public void setMetadata(RequestMeta metadata) {
            this.metadata = metadata;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Request getBody() {
            return this.body;
        }

        public void setBody(Request body) {
            this.body = body;
        }
    }
}

