/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.packagescan.classreading;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ClassReader {
    public static final int SKIP_CODE = 1;
    public static final int V19 = 63;
    public static final int SKIP_DEBUG = 2;
    public static final int SKIP_FRAMES = 4;
    public static final int EXPAND_FRAMES = 8;
    static final int EXPAND_ASM_INSNS = 256;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private static final int INPUT_STREAM_DATA_CHUNK_SIZE = 4096;
    @Deprecated
    public final byte[] b;
    public final int header;
    final byte[] classFileBuffer;
    private final int[] cpInfoOffsets;
    private final String[] constantUtf8Values;
    private final int maxStringLength;

    public ClassReader(byte[] classFile) {
        this(classFile, 0, classFile.length);
    }

    public ClassReader(byte[] classFileBuffer, int classFileOffset, int classFileLength) {
        this(classFileBuffer, classFileOffset, true);
    }

    ClassReader(byte[] classFileBuffer, int classFileOffset, boolean checkClassVersion) {
        this.classFileBuffer = classFileBuffer;
        this.b = classFileBuffer;
        if (checkClassVersion && this.readShort(classFileOffset + 6) > 63) {
            throw new IllegalArgumentException("Unsupported class file major version " + this.readShort(classFileOffset + 6));
        }
        int constantPoolCount = this.readUnsignedShort(classFileOffset + 8);
        this.cpInfoOffsets = new int[constantPoolCount];
        this.constantUtf8Values = new String[constantPoolCount];
        int currentCpInfoIndex = 1;
        int currentCpInfoOffset = classFileOffset + 10;
        int currentMaxStringLength = 0;
        boolean hasBootstrapMethods = false;
        boolean hasConstantDynamic = false;
        while (currentCpInfoIndex < constantPoolCount) {
            int cpInfoSize;
            this.cpInfoOffsets[currentCpInfoIndex++] = currentCpInfoOffset + 1;
            switch (classFileBuffer[currentCpInfoOffset]) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    cpInfoSize = 5;
                    break;
                }
                case 17: {
                    cpInfoSize = 5;
                    hasBootstrapMethods = true;
                    hasConstantDynamic = true;
                    break;
                }
                case 18: {
                    cpInfoSize = 5;
                    hasBootstrapMethods = true;
                    break;
                }
                case 5: 
                case 6: {
                    cpInfoSize = 9;
                    ++currentCpInfoIndex;
                    break;
                }
                case 1: {
                    cpInfoSize = 3 + this.readUnsignedShort(currentCpInfoOffset + 1);
                    if (cpInfoSize <= currentMaxStringLength) break;
                    currentMaxStringLength = cpInfoSize;
                    break;
                }
                case 15: {
                    cpInfoSize = 4;
                    break;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    cpInfoSize = 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            currentCpInfoOffset += cpInfoSize;
        }
        this.maxStringLength = currentMaxStringLength;
        this.header = currentCpInfoOffset;
    }

    public ClassReader(InputStream inputStream) throws IOException {
        this(ClassReader.readStream(inputStream, false));
    }

    public ClassReader(String className) throws IOException {
        this(ClassReader.readStream(ClassLoader.getSystemResourceAsStream(className.replace('.', '/') + ".class"), true));
    }

    /*
     * Loose catch block
     */
    private static byte[] readStream(InputStream inputStream, boolean close) throws IOException {
        if (inputStream == null) {
            throw new IOException("Class not found");
        }
        int bufferSize = ClassReader.calculateBufferSize(inputStream);
        try {
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                int bytesRead;
                byte[] data = new byte[bufferSize];
                int readCount = 0;
                while ((bytesRead = inputStream.read(data, 0, bufferSize)) != -1) {
                    outputStream.write(data, 0, bytesRead);
                    ++readCount;
                }
                outputStream.flush();
                if (readCount == 1) {
                    // empty if block
                }
                byte[] byArray = outputStream.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (close) {
                inputStream.close();
            }
        }
    }

    private static int calculateBufferSize(InputStream inputStream) throws IOException {
        int expectedLength = inputStream.available();
        if (expectedLength < 256) {
            return 4096;
        }
        return Math.min(expectedLength, 0x100000);
    }

    public int getAccess() {
        return this.readUnsignedShort(this.header);
    }

    public String getClassName() {
        return this.readClass(this.header + 2, new char[this.maxStringLength]);
    }

    public String getSuperName() {
        return this.readClass(this.header + 4, new char[this.maxStringLength]);
    }

    public String[] getInterfaces() {
        int currentOffset = this.header + 6;
        int interfacesCount = this.readUnsignedShort(currentOffset);
        String[] interfaces = new String[interfacesCount];
        if (interfacesCount > 0) {
            char[] charBuffer = new char[this.maxStringLength];
            for (int i = 0; i < interfacesCount; ++i) {
                interfaces[i] = this.readClass(currentOffset += 2, charBuffer);
            }
        }
        return interfaces;
    }

    final int getFirstAttributeOffset() {
        int currentOffset = this.header + 8 + this.readUnsignedShort(this.header + 6) * 2;
        int fieldsCount = this.readUnsignedShort(currentOffset);
        currentOffset += 2;
        while (fieldsCount-- > 0) {
            int attributesCount = this.readUnsignedShort(currentOffset + 6);
            currentOffset += 8;
            while (attributesCount-- > 0) {
                currentOffset += 6 + this.readInt(currentOffset + 2);
            }
        }
        int methodsCount = this.readUnsignedShort(currentOffset);
        currentOffset += 2;
        while (methodsCount-- > 0) {
            int attributesCount = this.readUnsignedShort(currentOffset + 6);
            currentOffset += 8;
            while (attributesCount-- > 0) {
                currentOffset += 6 + this.readInt(currentOffset + 2);
            }
        }
        return currentOffset + 2;
    }

    public int getItemCount() {
        return this.cpInfoOffsets.length;
    }

    public int getItem(int constantPoolEntryIndex) {
        return this.cpInfoOffsets[constantPoolEntryIndex];
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int readByte(int offset) {
        return this.classFileBuffer[offset] & 0xFF;
    }

    public int readUnsignedShort(int offset) {
        byte[] classBuffer = this.classFileBuffer;
        return (classBuffer[offset] & 0xFF) << 8 | classBuffer[offset + 1] & 0xFF;
    }

    public short readShort(int offset) {
        byte[] classBuffer = this.classFileBuffer;
        return (short)((classBuffer[offset] & 0xFF) << 8 | classBuffer[offset + 1] & 0xFF);
    }

    public int readInt(int offset) {
        byte[] classBuffer = this.classFileBuffer;
        return (classBuffer[offset] & 0xFF) << 24 | (classBuffer[offset + 1] & 0xFF) << 16 | (classBuffer[offset + 2] & 0xFF) << 8 | classBuffer[offset + 3] & 0xFF;
    }

    public long readLong(int offset) {
        long l1 = this.readInt(offset);
        long l0 = (long)this.readInt(offset + 4) & 0xFFFFFFFFL;
        return l1 << 32 | l0;
    }

    public String readUtf8(int offset, char[] charBuffer) {
        int constantPoolEntryIndex = this.readUnsignedShort(offset);
        if (offset == 0 || constantPoolEntryIndex == 0) {
            return null;
        }
        return this.readUtf(constantPoolEntryIndex, charBuffer);
    }

    final String readUtf(int constantPoolEntryIndex, char[] charBuffer) {
        String value = this.constantUtf8Values[constantPoolEntryIndex];
        if (value != null) {
            return value;
        }
        int cpInfoOffset = this.cpInfoOffsets[constantPoolEntryIndex];
        this.constantUtf8Values[constantPoolEntryIndex] = this.readUtf(cpInfoOffset + 2, this.readUnsignedShort(cpInfoOffset), charBuffer);
        return this.constantUtf8Values[constantPoolEntryIndex];
    }

    private String readUtf(int utfOffset, int utfLength, char[] charBuffer) {
        int currentOffset = utfOffset;
        int endOffset = currentOffset + utfLength;
        int strLength = 0;
        byte[] classBuffer = this.classFileBuffer;
        while (currentOffset < endOffset) {
            byte currentByte;
            if (((currentByte = classBuffer[currentOffset++]) & 0x80) == 0) {
                charBuffer[strLength++] = (char)(currentByte & 0x7F);
                continue;
            }
            if ((currentByte & 0xE0) == 192) {
                charBuffer[strLength++] = (char)(((currentByte & 0x1F) << 6) + (classBuffer[currentOffset++] & 0x3F));
                continue;
            }
            charBuffer[strLength++] = (char)(((currentByte & 0xF) << 12) + ((classBuffer[currentOffset++] & 0x3F) << 6) + (classBuffer[currentOffset++] & 0x3F));
        }
        return new String(charBuffer, 0, strLength);
    }

    private String readStringish(int offset, char[] charBuffer) {
        return this.readUtf8(this.cpInfoOffsets[this.readUnsignedShort(offset)], charBuffer);
    }

    public String readClass(int offset, char[] charBuffer) {
        return this.readStringish(offset, charBuffer);
    }

    public String readModule(int offset, char[] charBuffer) {
        return this.readStringish(offset, charBuffer);
    }

    public String readPackage(int offset, char[] charBuffer) {
        return this.readStringish(offset, charBuffer);
    }
}

