/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.trace.event.naming;

import com.alibaba.nacos.common.trace.HealthCheckType;
import com.alibaba.nacos.common.trace.event.naming.NamingTraceEvent;

public class HealthStateChangeTraceEvent
extends NamingTraceEvent {
    private static final long serialVersionUID = 6966396191118694597L;
    private String instanceIp;
    private int instancePort;
    private boolean isHealthy;
    private HealthCheckType healthCheckType;
    private String healthStateChangeReason;

    public String getInstanceIp() {
        return this.instanceIp;
    }

    public int getInstancePort() {
        return this.instancePort;
    }

    public String toInetAddr() {
        return this.instanceIp + ":" + this.instancePort;
    }

    public boolean isHealthy() {
        return this.isHealthy;
    }

    public HealthCheckType getHealthCheckType() {
        return this.healthCheckType;
    }

    public String getHealthStateChangeReason() {
        return this.healthStateChangeReason;
    }

    public HealthStateChangeTraceEvent(long eventTime, String serviceNamespace, String serviceGroup, String serviceName, String instanceIp, int instancePort, boolean isHealthy, String healthStateChangeReason) {
        super("HEALTH_STATE_CHANGE_TRACE_EVENT", eventTime, serviceNamespace, serviceGroup, serviceName);
        this.instanceIp = instanceIp;
        this.instancePort = instancePort;
        this.isHealthy = isHealthy;
        this.healthCheckType = this.getHealthCheckTypeFromReason(healthStateChangeReason);
        this.healthStateChangeReason = healthStateChangeReason;
    }

    public HealthCheckType getHealthCheckTypeFromReason(String reason) {
        if (reason.startsWith(HealthCheckType.HTTP_HEALTH_CHECK.getPrefix())) {
            return HealthCheckType.HTTP_HEALTH_CHECK;
        }
        if (reason.startsWith(HealthCheckType.TCP_SUPER_SENSE.getPrefix())) {
            return HealthCheckType.TCP_SUPER_SENSE;
        }
        if (reason.startsWith(HealthCheckType.MYSQL_HEALTH_CHECK.getPrefix())) {
            return HealthCheckType.MYSQL_HEALTH_CHECK;
        }
        return HealthCheckType.CLIENT_BEAT;
    }
}

