/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.lot.common;

import apsara.odps.lot.ExpressionProtos;
import com.aliyun.odps.lot.common.ArgumentNullException;
import com.aliyun.odps.lot.common.Language;
import com.aliyun.odps.lot.common.Resource;
import java.util.List;

public class TemporaryFunction {
    private String name;
    private List<Resource> resources;
    private String className;
    private Language language;

    public TemporaryFunction(String name, List<Resource> resources, String className, Language language) {
        if (name == null) {
            throw new ArgumentNullException("name");
        }
        if (resources == null) {
            throw new ArgumentNullException("resources");
        }
        if (resources.size() == 0) {
            throw new IllegalArgumentException("You must specify one resource at least for the temporary function '" + name + "' .");
        }
        if (className == null) {
            throw new ArgumentNullException("className");
        }
        this.name = name;
        this.resources = resources;
        this.className = className;
        this.language = language;
    }

    public String getName() {
        return this.name;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public String getClassName() {
        return this.className;
    }

    public Language getLanguage() {
        return this.language;
    }

    public ExpressionProtos.TemporaryFunction toProtoBuf() {
        ExpressionProtos.TemporaryFunction.Builder builder = ExpressionProtos.TemporaryFunction.newBuilder();
        builder.setName(this.name);
        builder.setClassName(this.className);
        for (Resource res : this.resources) {
            ExpressionProtos.TemporaryFunction.Resources.Builder r = ExpressionProtos.TemporaryFunction.Resources.newBuilder();
            r.setProject(res.getProject());
            r.setResourceName(res.getName());
            builder.addResources(r.build());
        }
        builder.setLanguage(this.language.toProtoBuf());
        return builder.build();
    }
}

