/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.speechlet.Directive;
import com.amazon.speech.ui.Card;
import com.amazon.speech.ui.OutputSpeech;
import com.amazon.speech.ui.Reprompt;
import java.util.List;

public class SpeechletResponse {
    private OutputSpeech outputSpeech = null;
    private Card card = null;
    private List<Directive> directives = null;
    private Reprompt reprompt = null;
    private Boolean shouldEndSession = true;

    public OutputSpeech getOutputSpeech() {
        return this.outputSpeech;
    }

    public void setOutputSpeech(OutputSpeech outputSpeech) {
        this.outputSpeech = outputSpeech;
    }

    @Deprecated
    public boolean getShouldEndSession() {
        if (this.shouldEndSession == null) {
            return false;
        }
        return this.shouldEndSession;
    }

    @Deprecated
    public void setShouldEndSession(boolean shouldEndSession) {
        this.shouldEndSession = shouldEndSession;
    }

    public Boolean getNullableShouldEndSession() {
        return this.shouldEndSession;
    }

    public void setNullableShouldEndSession(Boolean shouldEndSession) {
        this.shouldEndSession = shouldEndSession;
    }

    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    public void setDirectives(List<Directive> directives) {
        this.directives = directives;
    }

    public Reprompt getReprompt() {
        return this.reprompt;
    }

    public void setReprompt(Reprompt reprompt) {
        this.reprompt = reprompt;
    }

    public static SpeechletResponse newTellResponse(OutputSpeech outputSpeech) {
        if (outputSpeech == null) {
            throw new IllegalArgumentException("OutputSpeech cannot be null");
        }
        SpeechletResponse response = new SpeechletResponse();
        response.setNullableShouldEndSession(true);
        response.setOutputSpeech(outputSpeech);
        return response;
    }

    public static SpeechletResponse newTellResponse(OutputSpeech outputSpeech, Card card) {
        if (card == null) {
            throw new IllegalArgumentException("Card cannot be null");
        }
        SpeechletResponse response = SpeechletResponse.newTellResponse(outputSpeech);
        response.setCard(card);
        return response;
    }

    public static SpeechletResponse newAskResponse(OutputSpeech outputSpeech, Reprompt reprompt) {
        if (outputSpeech == null) {
            throw new IllegalArgumentException("OutputSpeech cannot be null");
        }
        if (reprompt == null) {
            throw new IllegalArgumentException("Reprompt cannot be null");
        }
        SpeechletResponse response = new SpeechletResponse();
        response.setNullableShouldEndSession(false);
        response.setOutputSpeech(outputSpeech);
        response.setReprompt(reprompt);
        return response;
    }

    public static SpeechletResponse newAskResponse(OutputSpeech outputSpeech, Reprompt reprompt, Card card) {
        if (card == null) {
            throw new IllegalArgumentException("Card cannot be null");
        }
        SpeechletResponse response = SpeechletResponse.newAskResponse(outputSpeech, reprompt);
        response.setCard(card);
        return response;
    }
}

