/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.interfaces.audioplayer;

import com.amazon.speech.speechlet.State;
import com.amazon.speech.speechlet.interfaces.audioplayer.AudioPlayerInterface;
import com.amazon.speech.speechlet.interfaces.audioplayer.PlayerActivity;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class AudioPlayerState
extends State<AudioPlayerInterface> {
    private final Long offsetInMilliseconds;
    private final String token;
    private final PlayerActivity playerActivity;

    public static Builder builder() {
        return new Builder();
    }

    private AudioPlayerState(Builder builder) {
        this.offsetInMilliseconds = builder.offsetInMilliseconds;
        this.token = builder.token;
        this.playerActivity = builder.playerActivity;
    }

    private AudioPlayerState(@JsonProperty(value="offsetInMilliseconds") Long offsetInMilliseconds, @JsonProperty(value="token") String token, @JsonProperty(value="playerActivity") PlayerActivity playerActivity) {
        this.offsetInMilliseconds = offsetInMilliseconds;
        this.token = token;
        this.playerActivity = playerActivity;
    }

    public Long getOffsetInMilliseconds() {
        return this.offsetInMilliseconds;
    }

    public String getToken() {
        return this.token;
    }

    public PlayerActivity getPlayerActivity() {
        return this.playerActivity;
    }

    @Override
    public Class<AudioPlayerInterface> getInterfaceClass() {
        return AudioPlayerInterface.class;
    }

    public static final class Builder {
        private Long offsetInMilliseconds;
        private String token;
        private PlayerActivity playerActivity;

        private Builder() {
        }

        public Builder withOffsetInMilliseconds(long offsetInMilliseconds) {
            this.offsetInMilliseconds = offsetInMilliseconds;
            return this;
        }

        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        public Builder withPlayerActivity(PlayerActivity playerActivity) {
            this.playerActivity = playerActivity;
            return this;
        }

        public AudioPlayerState build() {
            return new AudioPlayerState(this);
        }
    }
}

