/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.slu;

import com.amazon.speech.slu.ConfirmationStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.Validate;

public final class Slot {
    private final String name;
    private final String value;
    private final ConfirmationStatus confirmationStatus;

    public static Builder builder() {
        return new Builder();
    }

    private Slot(Builder builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.confirmationStatus = builder.confirmationStatus;
    }

    private Slot(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value, @JsonProperty(value="confirmationStatus") ConfirmationStatus confirmationStatus) {
        this.name = name;
        this.value = value;
        this.confirmationStatus = confirmationStatus;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public ConfirmationStatus getConfirmationStatus() {
        return this.confirmationStatus;
    }

    public static final class Builder {
        private String name;
        private String value;
        private ConfirmationStatus confirmationStatus;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withConfirmationStatus(ConfirmationStatus confirmationStatus) {
            this.confirmationStatus = confirmationStatus;
            return this;
        }

        public Slot build() {
            Validate.notBlank((CharSequence)this.name, (String)"Slot name must be defined", (Object[])new Object[0]);
            return new Slot(this);
        }
    }
}

