/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.json.SpeechletRequestEnvelope;
import com.amazon.speech.json.SpeechletResponseEnvelope;
import com.amazon.speech.speechlet.CoreSpeechletRequest;
import com.amazon.speech.speechlet.IntentRequest;
import com.amazon.speech.speechlet.LaunchRequest;
import com.amazon.speech.speechlet.Session;
import com.amazon.speech.speechlet.SessionEndedRequest;
import com.amazon.speech.speechlet.SessionStartedRequest;
import com.amazon.speech.speechlet.Speechlet;
import com.amazon.speech.speechlet.SpeechletException;
import com.amazon.speech.speechlet.SpeechletRequest;
import com.amazon.speech.speechlet.SpeechletRequestHandlerException;
import com.amazon.speech.speechlet.SpeechletResponse;
import com.amazon.speech.speechlet.SpeechletToSpeechletV2Adapter;
import com.amazon.speech.speechlet.SpeechletV2;
import com.amazon.speech.speechlet.interfaces.audioplayer.AudioPlayer;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.AudioPlayerRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.PlaybackFailedRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.PlaybackFinishedRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.PlaybackNearlyFinishedRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.PlaybackStartedRequest;
import com.amazon.speech.speechlet.interfaces.audioplayer.request.PlaybackStoppedRequest;
import com.amazon.speech.speechlet.interfaces.core.AccountLinkedRequest;
import com.amazon.speech.speechlet.interfaces.core.AlexaSkillEventRequest;
import com.amazon.speech.speechlet.interfaces.core.PermissionAcceptedRequest;
import com.amazon.speech.speechlet.interfaces.core.PermissionChangedRequest;
import com.amazon.speech.speechlet.interfaces.core.SkillDisabledEventRequest;
import com.amazon.speech.speechlet.interfaces.core.SkillEnabledEventRequest;
import com.amazon.speech.speechlet.interfaces.core.SkillEventListener;
import com.amazon.speech.speechlet.interfaces.display.Display;
import com.amazon.speech.speechlet.interfaces.display.request.DisplayRequest;
import com.amazon.speech.speechlet.interfaces.display.request.ElementSelectedRequest;
import com.amazon.speech.speechlet.interfaces.playbackcontroller.PlaybackController;
import com.amazon.speech.speechlet.interfaces.playbackcontroller.request.NextCommandIssuedRequest;
import com.amazon.speech.speechlet.interfaces.playbackcontroller.request.PauseCommandIssuedRequest;
import com.amazon.speech.speechlet.interfaces.playbackcontroller.request.PlayCommandIssuedRequest;
import com.amazon.speech.speechlet.interfaces.playbackcontroller.request.PlaybackControllerRequest;
import com.amazon.speech.speechlet.interfaces.playbackcontroller.request.PreviousCommandIssuedRequest;
import com.amazon.speech.speechlet.interfaces.system.System;
import com.amazon.speech.speechlet.interfaces.system.request.ExceptionEncounteredRequest;
import com.amazon.speech.speechlet.interfaces.system.request.SystemRequest;
import com.amazon.speech.speechlet.services.householdlist.AlexaHouseholdListEventRequest;
import com.amazon.speech.speechlet.services.householdlist.HouseholdListEventListener;
import com.amazon.speech.speechlet.services.householdlist.ListItemsCreatedRequest;
import com.amazon.speech.speechlet.services.householdlist.ListItemsDeletedRequest;
import com.amazon.speech.speechlet.services.householdlist.ListItemsUpdatedRequest;
import java.io.IOException;
import java.util.Locale;

public class SpeechletRequestDispatcher {
    private final SpeechletV2 speechlet;

    public SpeechletRequestDispatcher(SpeechletV2 speechlet) {
        this.speechlet = speechlet;
    }

    public SpeechletRequestDispatcher(Speechlet speechlet) {
        this(new SpeechletToSpeechletV2Adapter(speechlet));
    }

    public SpeechletResponseEnvelope dispatchSpeechletCall(SpeechletRequestEnvelope<?> requestEnvelope, Session session) throws IOException, SpeechletRequestHandlerException, SpeechletException {
        SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope;
        Object speechletRequest = requestEnvelope.getRequest();
        SpeechletResponseEnvelope responseEnvelope = new SpeechletResponseEnvelope();
        responseEnvelope.setVersion("1.0");
        if (session != null && session.isNew()) {
            String requestId = speechletRequest != null ? ((SpeechletRequest)speechletRequest).getRequestId() : null;
            Locale locale = speechletRequest != null ? ((SpeechletRequest)speechletRequest).getLocale() : null;
            SessionStartedRequest sessionStartedRequest = ((SessionStartedRequest.Builder)((SessionStartedRequest.Builder)SessionStartedRequest.builder().withRequestId(requestId)).withLocale(locale)).build();
            SpeechletRequestEnvelope<SessionStartedRequest> sessionStartedRequestEnvelope = SpeechletRequestEnvelope.builder().withContext(requestEnvelope.getContext()).withRequest(sessionStartedRequest).withSession(session).withVersion(requestEnvelope.getVersion()).build();
            try {
                this.speechlet.onSessionStarted(sessionStartedRequestEnvelope);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof SpeechletException) {
                    throw (SpeechletException)e.getCause();
                }
                throw e;
            }
        }
        SpeechletV2 speechletWithInterfaces = this.speechlet instanceof SpeechletToSpeechletV2Adapter ? ((SpeechletToSpeechletV2Adapter)this.speechlet).getSpeechlet() : this.speechlet;
        boolean saveSessionAttributes = false;
        SpeechletResponse speechletResponse = null;
        if (speechletRequest instanceof AlexaSkillEventRequest) {
            if (speechletRequest instanceof SkillEnabledEventRequest) {
                if (speechletWithInterfaces instanceof SkillEventListener) {
                    typeSpecificRequestEnvelope = requestEnvelope;
                    ((SkillEventListener)((Object)speechletWithInterfaces)).onSkillEnabled(typeSpecificRequestEnvelope);
                }
            } else if (speechletRequest instanceof SkillDisabledEventRequest) {
                if (speechletWithInterfaces instanceof SkillEventListener) {
                    typeSpecificRequestEnvelope = requestEnvelope;
                    ((SkillEventListener)((Object)speechletWithInterfaces)).onSkillDisabled(typeSpecificRequestEnvelope);
                }
            } else if (speechletRequest instanceof PermissionAcceptedRequest) {
                typeSpecificRequestEnvelope = requestEnvelope;
                ((SkillEventListener)((Object)speechletWithInterfaces)).onPermissionAccepted(typeSpecificRequestEnvelope);
            } else if (speechletRequest instanceof PermissionChangedRequest) {
                typeSpecificRequestEnvelope = requestEnvelope;
                ((SkillEventListener)((Object)speechletWithInterfaces)).onPermissionChanged(typeSpecificRequestEnvelope);
            } else if (speechletRequest instanceof AccountLinkedRequest) {
                typeSpecificRequestEnvelope = requestEnvelope;
                ((SkillEventListener)((Object)speechletWithInterfaces)).onAccountLinked(typeSpecificRequestEnvelope);
            }
        } else if (speechletRequest instanceof AlexaHouseholdListEventRequest) {
            if (speechletRequest instanceof ListItemsCreatedRequest) {
                typeSpecificRequestEnvelope = requestEnvelope;
                ((HouseholdListEventListener)((Object)speechletWithInterfaces)).onListItemsCreated(typeSpecificRequestEnvelope);
            } else if (speechletRequest instanceof ListItemsUpdatedRequest) {
                typeSpecificRequestEnvelope = requestEnvelope;
                ((HouseholdListEventListener)((Object)speechletWithInterfaces)).onListItemsUpdated(typeSpecificRequestEnvelope);
            } else if (speechletRequest instanceof ListItemsDeletedRequest) {
                typeSpecificRequestEnvelope = requestEnvelope;
                ((HouseholdListEventListener)((Object)speechletWithInterfaces)).onListItemsDeleted(typeSpecificRequestEnvelope);
            }
        } else if (speechletRequest instanceof AudioPlayerRequest) {
            if (speechletWithInterfaces instanceof AudioPlayer) {
                AudioPlayer audioPlayerSpeechlet = (AudioPlayer)((Object)speechletWithInterfaces);
                if (speechletRequest instanceof PlaybackFailedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope2 = requestEnvelope;
                    speechletResponse = audioPlayerSpeechlet.onPlaybackFailed(typeSpecificRequestEnvelope2);
                } else if (speechletRequest instanceof PlaybackFinishedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope3 = requestEnvelope;
                    speechletResponse = audioPlayerSpeechlet.onPlaybackFinished(typeSpecificRequestEnvelope3);
                } else if (speechletRequest instanceof PlaybackNearlyFinishedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope4 = requestEnvelope;
                    speechletResponse = audioPlayerSpeechlet.onPlaybackNearlyFinished(typeSpecificRequestEnvelope4);
                } else if (speechletRequest instanceof PlaybackStartedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope5 = requestEnvelope;
                    speechletResponse = audioPlayerSpeechlet.onPlaybackStarted(typeSpecificRequestEnvelope5);
                } else if (speechletRequest instanceof PlaybackStoppedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope6 = requestEnvelope;
                    speechletResponse = audioPlayerSpeechlet.onPlaybackStopped(typeSpecificRequestEnvelope6);
                }
            }
        } else if (speechletRequest instanceof PlaybackControllerRequest) {
            if (speechletWithInterfaces instanceof PlaybackController) {
                PlaybackController playbackControllerSpeechlet = (PlaybackController)((Object)speechletWithInterfaces);
                if (speechletRequest instanceof NextCommandIssuedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope7 = requestEnvelope;
                    speechletResponse = playbackControllerSpeechlet.onNextCommandIssued(typeSpecificRequestEnvelope7);
                } else if (speechletRequest instanceof PreviousCommandIssuedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope8 = requestEnvelope;
                    speechletResponse = playbackControllerSpeechlet.onPreviousCommandIssued(typeSpecificRequestEnvelope8);
                } else if (speechletRequest instanceof PauseCommandIssuedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope9 = requestEnvelope;
                    speechletResponse = playbackControllerSpeechlet.onPauseCommandIssued(typeSpecificRequestEnvelope9);
                } else if (speechletRequest instanceof PlayCommandIssuedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope10 = requestEnvelope;
                    speechletResponse = playbackControllerSpeechlet.onPlayCommandIssued(typeSpecificRequestEnvelope10);
                }
            }
        } else if (speechletRequest instanceof SystemRequest) {
            if (speechletWithInterfaces instanceof System) {
                System systemSpeechlet = (System)((Object)speechletWithInterfaces);
                if (speechletRequest instanceof ExceptionEncounteredRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope11 = requestEnvelope;
                    systemSpeechlet.onExceptionEncountered(typeSpecificRequestEnvelope11);
                }
            }
        } else if (speechletRequest instanceof DisplayRequest) {
            if (speechletWithInterfaces instanceof Display) {
                Display displaySpeechlet = (Display)((Object)speechletWithInterfaces);
                if (speechletRequest instanceof ElementSelectedRequest) {
                    SpeechletRequestEnvelope<SkillEnabledEventRequest> typeSpecificRequestEnvelope12 = requestEnvelope;
                    speechletResponse = displaySpeechlet.onElementSelected(typeSpecificRequestEnvelope12);
                    saveSessionAttributes = this.shouldSaveSessionAttributes(speechletResponse);
                }
            }
        } else if (speechletRequest instanceof CoreSpeechletRequest) {
            try {
                SpeechletRequestEnvelope<SkillEnabledEventRequest> parameterizedRequestEnvelope;
                if (speechletRequest instanceof SessionEndedRequest) {
                    parameterizedRequestEnvelope = requestEnvelope;
                    this.speechlet.onSessionEnded(parameterizedRequestEnvelope);
                }
                if (speechletRequest instanceof IntentRequest) {
                    parameterizedRequestEnvelope = requestEnvelope;
                    speechletResponse = this.speechlet.onIntent(parameterizedRequestEnvelope);
                } else if (speechletRequest instanceof LaunchRequest) {
                    parameterizedRequestEnvelope = requestEnvelope;
                    speechletResponse = this.speechlet.onLaunch(parameterizedRequestEnvelope);
                }
                saveSessionAttributes = this.shouldSaveSessionAttributes(speechletResponse);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof SpeechletException) {
                    throw (SpeechletException)e.getCause();
                }
                throw e;
            }
        } else {
            String requestType = speechletRequest != null ? speechletRequest.getClass().getName() : null;
            String message = String.format("Unsupported request type %s. Consider updating your SDK version. Request envelope version %s, SDK version %s", requestType, requestEnvelope.getVersion(), "1.0");
            throw new SpeechletRequestHandlerException(message);
        }
        responseEnvelope.setResponse(speechletResponse);
        if (saveSessionAttributes && session != null) {
            responseEnvelope.setSessionAttributes(session.getAttributes());
        }
        return responseEnvelope;
    }

    private boolean shouldSaveSessionAttributes(SpeechletResponse speechletResponse) {
        if (speechletResponse != null && speechletResponse.getNullableShouldEndSession() != null) {
            return speechletResponse.getNullableShouldEndSession() == false;
        }
        return true;
    }
}

