/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backupgateway.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.backupgateway.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImportHypervisorConfigurationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String host;
    private String kmsKeyArn;
    private String name;
    private String password;
    private List<Tag> tags;
    private String username;

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public ImportHypervisorConfigurationRequest withHost(String host) {
        this.setHost(host);
        return this;
    }

    public void setKmsKeyArn(String kmsKeyArn) {
        this.kmsKeyArn = kmsKeyArn;
    }

    public String getKmsKeyArn() {
        return this.kmsKeyArn;
    }

    public ImportHypervisorConfigurationRequest withKmsKeyArn(String kmsKeyArn) {
        this.setKmsKeyArn(kmsKeyArn);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ImportHypervisorConfigurationRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public ImportHypervisorConfigurationRequest withPassword(String password) {
        this.setPassword(password);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public ImportHypervisorConfigurationRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public ImportHypervisorConfigurationRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public ImportHypervisorConfigurationRequest withUsername(String username) {
        this.setUsername(username);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHost() != null) {
            sb.append("Host: ").append(this.getHost()).append(",");
        }
        if (this.getKmsKeyArn() != null) {
            sb.append("KmsKeyArn: ").append(this.getKmsKeyArn()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPassword() != null) {
            sb.append("Password: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getUsername() != null) {
            sb.append("Username: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportHypervisorConfigurationRequest)) {
            return false;
        }
        ImportHypervisorConfigurationRequest other = (ImportHypervisorConfigurationRequest)obj;
        if (other.getHost() == null ^ this.getHost() == null) {
            return false;
        }
        if (other.getHost() != null && !other.getHost().equals(this.getHost())) {
            return false;
        }
        if (other.getKmsKeyArn() == null ^ this.getKmsKeyArn() == null) {
            return false;
        }
        if (other.getKmsKeyArn() != null && !other.getKmsKeyArn().equals(this.getKmsKeyArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPassword() == null ^ this.getPassword() == null) {
            return false;
        }
        if (other.getPassword() != null && !other.getPassword().equals(this.getPassword())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        return other.getUsername() == null || other.getUsername().equals(this.getUsername());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHost() == null ? 0 : this.getHost().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyArn() == null ? 0 : this.getKmsKeyArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPassword() == null ? 0 : this.getPassword().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        return hashCode;
    }

    public ImportHypervisorConfigurationRequest clone() {
        return (ImportHypervisorConfigurationRequest)super.clone();
    }
}

