/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProjectionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class LocalSecondaryIndexDescriptionJsonMarshaller {
    private static LocalSecondaryIndexDescriptionJsonMarshaller instance;

    public void marshall(LocalSecondaryIndexDescription localSecondaryIndexDescription, JSONWriter jsonWriter) {
        if (localSecondaryIndexDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<KeySchemaElement> keySchemaList;
            jsonWriter.object();
            if (localSecondaryIndexDescription.getIndexName() != null) {
                jsonWriter.key("IndexName").value((Object)localSecondaryIndexDescription.getIndexName());
            }
            if ((keySchemaList = localSecondaryIndexDescription.getKeySchema()) != null) {
                jsonWriter.key("KeySchema");
                jsonWriter.array();
                for (KeySchemaElement keySchemaListValue : keySchemaList) {
                    if (keySchemaListValue == null) continue;
                    KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (localSecondaryIndexDescription.getProjection() != null) {
                jsonWriter.key("Projection");
                ProjectionJsonMarshaller.getInstance().marshall(localSecondaryIndexDescription.getProjection(), jsonWriter);
            }
            if (localSecondaryIndexDescription.getIndexSizeBytes() != null) {
                jsonWriter.key("IndexSizeBytes").value((Object)localSecondaryIndexDescription.getIndexSizeBytes());
            }
            if (localSecondaryIndexDescription.getItemCount() != null) {
                jsonWriter.key("ItemCount").value((Object)localSecondaryIndexDescription.getItemCount());
            }
            if (localSecondaryIndexDescription.getIndexArn() != null) {
                jsonWriter.key("IndexArn").value((Object)localSecondaryIndexDescription.getIndexArn());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LocalSecondaryIndexDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LocalSecondaryIndexDescriptionJsonMarshaller();
        }
        return instance;
    }
}

