/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.xspec;

import com.amazonaws.annotation.Beta;
import com.amazonaws.services.dynamodbv2.xspec.ExpressionSpec;
import com.amazonaws.services.dynamodbv2.xspec.ExpressionSpecBuilder;
import com.amazonaws.services.dynamodbv2.xspec.SubstitutionContext;
import java.util.Collections;
import java.util.Map;

@Beta
public final class ScanExpressionSpec
extends ExpressionSpec {
    private final String projectionExpression;
    private final String filterExpression;
    private final Map<String, String> nameMap;
    private final Map<String, Object> valueMap;

    ScanExpressionSpec(ExpressionSpecBuilder builder) {
        SubstitutionContext context = new SubstitutionContext();
        this.filterExpression = builder.buildConditionExpression(context);
        this.projectionExpression = builder.buildProjectionExpression(context);
        Map<String, String> nameMap = context.getNameMap();
        this.nameMap = nameMap == null ? null : Collections.unmodifiableMap(nameMap);
        Map<String, Object> valueMap = context.getValueMap();
        this.valueMap = valueMap == null ? null : Collections.unmodifiableMap(valueMap);
    }

    public String getProjectionExpression() {
        return this.projectionExpression;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    @Override
    public Map<String, String> getNameMap() {
        return this.nameMap;
    }

    public Map<String, Object> getValueMap() {
        return this.valueMap;
    }
}

