/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class AttributeValueJsonMarshaller {
    private static AttributeValueJsonMarshaller instance;

    public void marshall(AttributeValue attributeValue, SdkJsonGenerator jsonGenerator) {
        if (attributeValue == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<AttributeValue> lList;
            Map<String, AttributeValue> mMap;
            List<ByteBuffer> bSList;
            List<String> nSList;
            List<String> sSList;
            jsonGenerator.writeStartObject();
            if (attributeValue.getS() != null) {
                jsonGenerator.writeFieldName("S").writeValue(attributeValue.getS());
            }
            if (attributeValue.getN() != null) {
                jsonGenerator.writeFieldName("N").writeValue(attributeValue.getN());
            }
            if (attributeValue.getB() != null) {
                jsonGenerator.writeFieldName("B").writeValue(attributeValue.getB());
            }
            if ((sSList = attributeValue.getSS()) != null) {
                jsonGenerator.writeFieldName("SS");
                jsonGenerator.writeStartArray();
                for (String sSListValue : sSList) {
                    if (sSListValue == null) continue;
                    jsonGenerator.writeValue(sSListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((nSList = attributeValue.getNS()) != null) {
                jsonGenerator.writeFieldName("NS");
                jsonGenerator.writeStartArray();
                for (String nSListValue : nSList) {
                    if (nSListValue == null) continue;
                    jsonGenerator.writeValue(nSListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((bSList = attributeValue.getBS()) != null) {
                jsonGenerator.writeFieldName("BS");
                jsonGenerator.writeStartArray();
                for (ByteBuffer bSListValue : bSList) {
                    if (bSListValue == null) continue;
                    jsonGenerator.writeValue(bSListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((mMap = attributeValue.getM()) != null) {
                jsonGenerator.writeFieldName("M");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> mMapValue : mMap.entrySet()) {
                    if (mMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(mMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(mMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if ((lList = attributeValue.getL()) != null) {
                jsonGenerator.writeFieldName("L");
                jsonGenerator.writeStartArray();
                for (AttributeValue lListValue : lList) {
                    if (lListValue == null) continue;
                    AttributeValueJsonMarshaller.getInstance().marshall(lListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (attributeValue.getNULL() != null) {
                jsonGenerator.writeFieldName("NULL").writeValue(attributeValue.getNULL().booleanValue());
            }
            if (attributeValue.getBOOL() != null) {
                jsonGenerator.writeFieldName("BOOL").writeValue(attributeValue.getBOOL().booleanValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AttributeValueJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AttributeValueJsonMarshaller();
        }
        return instance;
    }
}

