/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.Capacity;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.transform.CapacityJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.Map;

public class ConsumedCapacityJsonMarshaller {
    private static ConsumedCapacityJsonMarshaller instance;

    public void marshall(ConsumedCapacity consumedCapacity, StructuredJsonGenerator jsonGenerator) {
        if (consumedCapacity == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, Capacity> globalSecondaryIndexesMap;
            Map<String, Capacity> localSecondaryIndexesMap;
            jsonGenerator.writeStartObject();
            if (consumedCapacity.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(consumedCapacity.getTableName());
            }
            if (consumedCapacity.getCapacityUnits() != null) {
                jsonGenerator.writeFieldName("CapacityUnits").writeValue(consumedCapacity.getCapacityUnits().doubleValue());
            }
            if (consumedCapacity.getTable() != null) {
                jsonGenerator.writeFieldName("Table");
                CapacityJsonMarshaller.getInstance().marshall(consumedCapacity.getTable(), jsonGenerator);
            }
            if ((localSecondaryIndexesMap = consumedCapacity.getLocalSecondaryIndexes()) != null) {
                jsonGenerator.writeFieldName("LocalSecondaryIndexes");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Capacity> localSecondaryIndexesMapValue : localSecondaryIndexesMap.entrySet()) {
                    if (localSecondaryIndexesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(localSecondaryIndexesMapValue.getKey());
                    CapacityJsonMarshaller.getInstance().marshall(localSecondaryIndexesMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if ((globalSecondaryIndexesMap = consumedCapacity.getGlobalSecondaryIndexes()) != null) {
                jsonGenerator.writeFieldName("GlobalSecondaryIndexes");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Capacity> globalSecondaryIndexesMapValue : globalSecondaryIndexesMap.entrySet()) {
                    if (globalSecondaryIndexesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(globalSecondaryIndexesMapValue.getKey());
                    CapacityJsonMarshaller.getInstance().marshall(globalSecondaryIndexesMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ConsumedCapacityJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ConsumedCapacityJsonMarshaller();
        }
        return instance;
    }
}

