/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonDynamoDBAsyncClient
extends AmazonDynamoDBClient
implements AmazonDynamoDBAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonDynamoDBAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonDynamoDBAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonDynamoDBAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonDynamoDBAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, new ClientConfiguration(), executorService);
    }

    public AmazonDynamoDBAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonDynamoDBAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(final BatchGetItemRequest batchGetItemRequest) {
        return this.executorService.submit(new Callable<BatchGetItemResult>(){

            @Override
            public BatchGetItemResult call() {
                return AmazonDynamoDBAsyncClient.this.batchGetItem(batchGetItemRequest);
            }
        });
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(final BatchGetItemRequest batchGetItemRequest, final AsyncHandler<BatchGetItemRequest, BatchGetItemResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchGetItemResult>(){

            @Override
            public BatchGetItemResult call() throws Exception {
                BatchGetItemResult result;
                try {
                    result = AmazonDynamoDBAsyncClient.this.batchGetItem(batchGetItemRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)batchGetItemRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(Map<String, KeysAndAttributes> requestItems, String returnConsumedCapacity) {
        return this.batchGetItemAsync(new BatchGetItemRequest().withRequestItems(requestItems).withReturnConsumedCapacity(returnConsumedCapacity));
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(Map<String, KeysAndAttributes> requestItems, String returnConsumedCapacity, AsyncHandler<BatchGetItemRequest, BatchGetItemResult> asyncHandler) {
        return this.batchGetItemAsync(new BatchGetItemRequest().withRequestItems(requestItems).withReturnConsumedCapacity(returnConsumedCapacity), asyncHandler);
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(Map<String, KeysAndAttributes> requestItems) {
        return this.batchGetItemAsync(new BatchGetItemRequest().withRequestItems(requestItems));
    }

    @Override
    public Future<BatchGetItemResult> batchGetItemAsync(Map<String, KeysAndAttributes> requestItems, AsyncHandler<BatchGetItemRequest, BatchGetItemResult> asyncHandler) {
        return this.batchGetItemAsync(new BatchGetItemRequest().withRequestItems(requestItems), asyncHandler);
    }

    @Override
    public Future<BatchWriteItemResult> batchWriteItemAsync(final BatchWriteItemRequest batchWriteItemRequest) {
        return this.executorService.submit(new Callable<BatchWriteItemResult>(){

            @Override
            public BatchWriteItemResult call() {
                return AmazonDynamoDBAsyncClient.this.batchWriteItem(batchWriteItemRequest);
            }
        });
    }

    @Override
    public Future<BatchWriteItemResult> batchWriteItemAsync(final BatchWriteItemRequest batchWriteItemRequest, final AsyncHandler<BatchWriteItemRequest, BatchWriteItemResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchWriteItemResult>(){

            @Override
            public BatchWriteItemResult call() throws Exception {
                BatchWriteItemResult result;
                try {
                    result = AmazonDynamoDBAsyncClient.this.batchWriteItem(batchWriteItemRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)batchWriteItemRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<BatchWriteItemResult> batchWriteItemAsync(Map<String, List<WriteRequest>> requestItems) {
        return this.batchWriteItemAsync(new BatchWriteItemRequest().withRequestItems(requestItems));
    }

    @Override
    public Future<BatchWriteItemResult> batchWriteItemAsync(Map<String, List<WriteRequest>> requestItems, AsyncHandler<BatchWriteItemRequest, BatchWriteItemResult> asyncHandler) {
        return this.batchWriteItemAsync(new BatchWriteItemRequest().withRequestItems(requestItems), asyncHandler);
    }

    @Override
    public Future<CreateTableResult> createTableAsync(final CreateTableRequest createTableRequest) {
        return this.executorService.submit(new Callable<CreateTableResult>(){

            @Override
            public CreateTableResult call() {
                return AmazonDynamoDBAsyncClient.this.createTable(createTableRequest);
            }
        });
    }

    @Override
    public Future<CreateTableResult> createTableAsync(final CreateTableRequest createTableRequest, final AsyncHandler<CreateTableRequest, CreateTableResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateTableResult>(){

            @Override
            public CreateTableResult call() throws Exception {
                CreateTableResult result;
                try {
                    result = AmazonDynamoDBAsyncClient.this.createTable(createTableRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createTableRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateTableResult> createTableAsync(List<AttributeDefinition> attributeDefinitions, String tableName, List<KeySchemaElement> keySchema, ProvisionedThroughput provisionedThroughput) {
        return this.createTableAsync(new CreateTableRequest().withAttributeDefinitions(attributeDefinitions).withTableName(tableName).withKeySchema(keySchema).withProvisionedThroughput(provisionedThroughput));
    }

    @Override
    public Future<CreateTableResult> createTableAsync(List<AttributeDefinition> attributeDefinitions, String tableName, List<KeySchemaElement> keySchema, ProvisionedThroughput provisionedThroughput, AsyncHandler<CreateTableRequest, CreateTableResult> asyncHandler) {
        return this.createTableAsync(new CreateTableRequest().withAttributeDefinitions(attributeDefinitions).withTableName(tableName).withKeySchema(keySchema).withProvisionedThroughput(provisionedThroughput), asyncHandler);
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(final DeleteItemRequest deleteItemRequest) {
        return this.executorService.submit(new Callable<DeleteItemResult>(){

            @Override
            public DeleteItemResult call() {
                return AmazonDynamoDBAsyncClient.this.deleteItem(deleteItemRequest);
            }
        });
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(final DeleteItemRequest deleteItemRequest, final AsyncHandler<DeleteItemRequest, DeleteItemResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteItemResult>(){

            @Override
            public DeleteItemResult call() throws Exception {
                DeleteItemResult result;
                try {
                    result = AmazonDynamoDBAsyncClient.this.deleteItem(deleteItemRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteItemRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(String tableName, Map<String, AttributeValue> key) {
        return this.deleteItemAsync(new DeleteItemRequest().withTableName(tableName).withKey(key));
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(String tableName, Map<String, AttributeValue> key, AsyncHandler<DeleteItemRequest, DeleteItemResult> asyncHandler) {
        return this.deleteItemAsync(new DeleteItemRequest().withTableName(tableName).withKey(key), asyncHandler);
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(String tableName, Map<String, AttributeValue> key, String returnValues) {
        return this.deleteItemAsync(new DeleteItemRequest().withTableName(tableName).withKey(key).withReturnValues(returnValues));
    }

    @Override
    public Future<DeleteItemResult> deleteItemAsync(String tableName, Map<String, AttributeValue> key, String returnValues, AsyncHandler<DeleteItemRequest, DeleteItemResult> asyncHandler) {
        return this.deleteItemAsync(new DeleteItemRequest().withTableName(tableName).withKey(key).withReturnValues(returnValues), asyncHandler);
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(final DeleteTableRequest deleteTableRequest) {
        return this.executorService.submit(new Callable<DeleteTableResult>(){

            @Override
            public DeleteTableResult call() {
                return AmazonDynamoDBAsyncClient.this.deleteTable(deleteTableRequest);
            }
        });
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(final DeleteTableRequest deleteTableRequest, final AsyncHandler<DeleteTableRequest, DeleteTableResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteTableResult>(){

            @Override
            public DeleteTableResult call() throws Exception {
                DeleteTableResult result;
                try {
                    result = AmazonDynamoDBAsyncClient.this.deleteTable(deleteTableRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteTableRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(String tableName) {
        return this.deleteTableAsync(new DeleteTableRequest().withTableName(tableName));
    }

    @Override
    public Future<DeleteTableResult> deleteTableAsync(String tableName, AsyncHandler<DeleteTableRequest, DeleteTableResult> asyncHandler) {
        return this.deleteTableAsync(new DeleteTableRequest().withTableName(tableName), asyncHandler);
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(final DescribeTableRequest describeTableRequest) {
        return this.executorService.submit(new Callable<DescribeTableResult>(){

            @Override
            public DescribeTableResult call() {
                return AmazonDynamoDBAsyncClient.this.describeTable(describeTableRequest);
            }
        });
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(final DescribeTableRequest describeTableRequest, final AsyncHandler<DescribeTableRequest, DescribeTableResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeTableResult>(){

            @Override
            public DescribeTableResult call() throws Exception {
                DescribeTableResult result;
                try {
                    result = AmazonDynamoDBAsyncClient.this.describeTable(describeTableRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeTableRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(String tableName) {
        return this.describeTableAsync(new DescribeTableRequest().withTableName(tableName));
    }

    @Override
    public Future<DescribeTableResult> describeTableAsync(String tableName, AsyncHandler<DescribeTableRequest, DescribeTableResult> asyncHandler) {
        return this.describeTableAsync(new DescribeTableRequest().withTableName(tableName), asyncHandler);
    }

    @Override
    public Future<GetItemResult> getItemAsync(final GetItemRequest getItemRequest) {
        return this.executorService.submit(new Callable<GetItemResult>(){

            @Override
            public GetItemResult call() {
                return AmazonDynamoDBAsyncClient.this.getItem(getItemRequest);
            }
        });
    }

    @Override
    public Future<GetItemResult> getItemAsync(final GetItemRequest getItemRequest, final AsyncHandler<GetItemRequest, GetItemResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetItemResult>(){

            @Override
            public GetItemResult call() throws Exception {
                GetItemResult result;
                try {
                    result = AmazonDynamoDBAsyncClient.this.getItem(getItemRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getItemRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetItemResult> getItemAsync(String tableName, Map<String, AttributeValue> key) {
        return this.getItemAsync(new GetItemRequest().withTableName(tableName).withKey(key));
    }

    @Override
    public Future<GetItemResult> getItemAsync(String tableName, Map<String, AttributeValue> key, AsyncHandler<GetItemRequest, GetItemResult> asyncHandler) {
        return this.getItemAsync(new GetItemRequest().withTableName(tableName).withKey(key), asyncHandler);
    }

    @Override
    public Future<GetItemResult> getItemAsync(String tableName, Map<String, AttributeValue> key, Boolean consistentRead) {
        return this.getItemAsync(new GetItemRequest().withTableName(tableName).withKey(key).withConsistentRead(consistentRead));
    }

    @Override
    public Future<GetItemResult> getItemAsync(String tableName, Map<String, AttributeValue> key, Boolean consistentRead, AsyncHandler<GetItemRequest, GetItemResult> asyncHandler) {
        return this.getItemAsync(new GetItemRequest().withTableName(tableName).withKey(key).withConsistentRead(consistentRead), asyncHandler);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(final ListTablesRequest listTablesRequest) {
        return this.executorService.submit(new Callable<ListTablesResult>(){

            @Override
            public ListTablesResult call() {
                return AmazonDynamoDBAsyncClient.this.listTables(listTablesRequest);
            }
        });
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(final ListTablesRequest listTablesRequest, final AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTablesResult>(){

            @Override
            public ListTablesResult call() throws Exception {
                ListTablesResult result;
                try {
                    result = AmazonDynamoDBAsyncClient.this.listTables(listTablesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listTablesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTablesResult> listTablesAsync() {
        return this.listTablesAsync(new ListTablesRequest());
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.listTablesAsync(new ListTablesRequest(), asyncHandler);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(String exclusiveStartTableName) {
        return this.listTablesAsync(new ListTablesRequest().withExclusiveStartTableName(exclusiveStartTableName));
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(String exclusiveStartTableName, AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.listTablesAsync(new ListTablesRequest().withExclusiveStartTableName(exclusiveStartTableName), asyncHandler);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(String exclusiveStartTableName, Integer limit) {
        return this.listTablesAsync(new ListTablesRequest().withExclusiveStartTableName(exclusiveStartTableName).withLimit(limit));
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(String exclusiveStartTableName, Integer limit, AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.listTablesAsync(new ListTablesRequest().withExclusiveStartTableName(exclusiveStartTableName).withLimit(limit), asyncHandler);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(Integer limit) {
        return this.listTablesAsync(new ListTablesRequest().withLimit(limit));
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(Integer limit, AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        return this.listTablesAsync(new ListTablesRequest().withLimit(limit), asyncHandler);
    }

    @Override
    public Future<PutItemResult> putItemAsync(final PutItemRequest putItemRequest) {
        return this.executorService.submit(new Callable<PutItemResult>(){

            @Override
            public PutItemResult call() {
                return AmazonDynamoDBAsyncClient.this.putItem(putItemRequest);
            }
        });
    }

    @Override
    public Future<PutItemResult> putItemAsync(final PutItemRequest putItemRequest, final AsyncHandler<PutItemRequest, PutItemResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutItemResult>(){

            @Override
            public PutItemResult call() throws Exception {
                PutItemResult result;
                try {
                    result = AmazonDynamoDBAsyncClient.this.putItem(putItemRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)putItemRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<PutItemResult> putItemAsync(String tableName, Map<String, AttributeValue> item) {
        return this.putItemAsync(new PutItemRequest().withTableName(tableName).withItem(item));
    }

    @Override
    public Future<PutItemResult> putItemAsync(String tableName, Map<String, AttributeValue> item, AsyncHandler<PutItemRequest, PutItemResult> asyncHandler) {
        return this.putItemAsync(new PutItemRequest().withTableName(tableName).withItem(item), asyncHandler);
    }

    @Override
    public Future<PutItemResult> putItemAsync(String tableName, Map<String, AttributeValue> item, String returnValues) {
        return this.putItemAsync(new PutItemRequest().withTableName(tableName).withItem(item).withReturnValues(returnValues));
    }

    @Override
    public Future<PutItemResult> putItemAsync(String tableName, Map<String, AttributeValue> item, String returnValues, AsyncHandler<PutItemRequest, PutItemResult> asyncHandler) {
        return this.putItemAsync(new PutItemRequest().withTableName(tableName).withItem(item).withReturnValues(returnValues), asyncHandler);
    }

    @Override
    public Future<QueryResult> queryAsync(final QueryRequest queryRequest) {
        return this.executorService.submit(new Callable<QueryResult>(){

            @Override
            public QueryResult call() {
                return AmazonDynamoDBAsyncClient.this.query(queryRequest);
            }
        });
    }

    @Override
    public Future<QueryResult> queryAsync(final QueryRequest queryRequest, final AsyncHandler<QueryRequest, QueryResult> asyncHandler) {
        return this.executorService.submit(new Callable<QueryResult>(){

            @Override
            public QueryResult call() throws Exception {
                QueryResult result;
                try {
                    result = AmazonDynamoDBAsyncClient.this.query(queryRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)queryRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ScanResult> scanAsync(final ScanRequest scanRequest) {
        return this.executorService.submit(new Callable<ScanResult>(){

            @Override
            public ScanResult call() {
                return AmazonDynamoDBAsyncClient.this.scan(scanRequest);
            }
        });
    }

    @Override
    public Future<ScanResult> scanAsync(final ScanRequest scanRequest, final AsyncHandler<ScanRequest, ScanResult> asyncHandler) {
        return this.executorService.submit(new Callable<ScanResult>(){

            @Override
            public ScanResult call() throws Exception {
                ScanResult result;
                try {
                    result = AmazonDynamoDBAsyncClient.this.scan(scanRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)scanRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, List<String> attributesToGet) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withAttributesToGet(attributesToGet));
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, List<String> attributesToGet, AsyncHandler<ScanRequest, ScanResult> asyncHandler) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withAttributesToGet(attributesToGet), asyncHandler);
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, Map<String, Condition> scanFilter) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withScanFilter(scanFilter));
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, Map<String, Condition> scanFilter, AsyncHandler<ScanRequest, ScanResult> asyncHandler) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withScanFilter(scanFilter), asyncHandler);
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, List<String> attributesToGet, Map<String, Condition> scanFilter) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withAttributesToGet(attributesToGet).withScanFilter(scanFilter));
    }

    @Override
    public Future<ScanResult> scanAsync(String tableName, List<String> attributesToGet, Map<String, Condition> scanFilter, AsyncHandler<ScanRequest, ScanResult> asyncHandler) {
        return this.scanAsync(new ScanRequest().withTableName(tableName).withAttributesToGet(attributesToGet).withScanFilter(scanFilter), asyncHandler);
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(final UpdateItemRequest updateItemRequest) {
        return this.executorService.submit(new Callable<UpdateItemResult>(){

            @Override
            public UpdateItemResult call() {
                return AmazonDynamoDBAsyncClient.this.updateItem(updateItemRequest);
            }
        });
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(final UpdateItemRequest updateItemRequest, final AsyncHandler<UpdateItemRequest, UpdateItemResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateItemResult>(){

            @Override
            public UpdateItemResult call() throws Exception {
                UpdateItemResult result;
                try {
                    result = AmazonDynamoDBAsyncClient.this.updateItem(updateItemRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateItemRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates) {
        return this.updateItemAsync(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates));
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, AsyncHandler<UpdateItemRequest, UpdateItemResult> asyncHandler) {
        return this.updateItemAsync(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates), asyncHandler);
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, String returnValues) {
        return this.updateItemAsync(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates).withReturnValues(returnValues));
    }

    @Override
    public Future<UpdateItemResult> updateItemAsync(String tableName, Map<String, AttributeValue> key, Map<String, AttributeValueUpdate> attributeUpdates, String returnValues, AsyncHandler<UpdateItemRequest, UpdateItemResult> asyncHandler) {
        return this.updateItemAsync(new UpdateItemRequest().withTableName(tableName).withKey(key).withAttributeUpdates(attributeUpdates).withReturnValues(returnValues), asyncHandler);
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(final UpdateTableRequest updateTableRequest) {
        return this.executorService.submit(new Callable<UpdateTableResult>(){

            @Override
            public UpdateTableResult call() {
                return AmazonDynamoDBAsyncClient.this.updateTable(updateTableRequest);
            }
        });
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(final UpdateTableRequest updateTableRequest, final AsyncHandler<UpdateTableRequest, UpdateTableResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateTableResult>(){

            @Override
            public UpdateTableResult call() throws Exception {
                UpdateTableResult result;
                try {
                    result = AmazonDynamoDBAsyncClient.this.updateTable(updateTableRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateTableRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(String tableName, ProvisionedThroughput provisionedThroughput) {
        return this.updateTableAsync(new UpdateTableRequest().withTableName(tableName).withProvisionedThroughput(provisionedThroughput));
    }

    @Override
    public Future<UpdateTableResult> updateTableAsync(String tableName, ProvisionedThroughput provisionedThroughput, AsyncHandler<UpdateTableRequest, UpdateTableResult> asyncHandler) {
        return this.updateTableAsync(new UpdateTableRequest().withTableName(tableName).withProvisionedThroughput(provisionedThroughput), asyncHandler);
    }
}

