/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchema;
import com.amazonaws.services.dynamodbv2.datamodeling.ConversionSchemas;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperModelFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.ItemConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.S3ClientCache;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardAnnotationMaps;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardAttributeTypes;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardBeanProperties;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardParameterTypes;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@SdkInternalApi
final class StandardModelFactories {
    StandardModelFactories() {
    }

    static final DynamoDBMapperModelFactory.Factory of(ConversionSchema.Dependencies depends) {
        return new SchemaFactoryFactory(depends);
    }

    private static enum Version {
        V1_0{

            @Override
            final void include(StandardAttributeTypes.Conversions<Object> conversions) {
                conversions.with(conversions.new StandardAttributeTypes.Conversions.AllScalars());
                conversions.with(conversions.new StandardAttributeTypes.Conversions.AllScalarSets());
                conversions.with(conversions.new StandardAttributeTypes.Conversions.AnyObjectStringSet());
            }

            @Override
            final ConversionSchema schema() {
                return ConversionSchemas.V1;
            }
        }
        ,
        V1_5{

            @Override
            final void include(StandardAttributeTypes.Conversions<Object> conversions) {
                conversions.with(conversions.new StandardAttributeTypes.Conversions.AllScalars());
                conversions.with(conversions.new StandardAttributeTypes.Conversions.AllScalarSets());
                conversions.with(conversions.new StandardAttributeTypes.Conversions.AnyObjectStringSet());
                conversions.with(conversions.new StandardAttributeTypes.Conversions.AnyList());
                conversions.with(conversions.new StandardAttributeTypes.Conversions.AnyMap());
                conversions.with(conversions.new StandardAttributeTypes.Conversions.AnyDocumentObject());
            }

            @Override
            final ConversionSchema schema() {
                return ConversionSchemas.V2_COMPATIBLE;
            }
        }
        ,
        V2_0{

            @Override
            final void include(StandardAttributeTypes.Conversions<Object> conversions) {
                conversions.with(conversions.new StandardAttributeTypes.Conversions.NativeBool());
                conversions.with(conversions.new StandardAttributeTypes.Conversions.AllScalars());
                conversions.with(conversions.new StandardAttributeTypes.Conversions.NativeBoolSet());
                conversions.with(conversions.new StandardAttributeTypes.Conversions.AllScalarSets());
                conversions.with(conversions.new StandardAttributeTypes.Conversions.AnySet());
                conversions.with(conversions.new StandardAttributeTypes.Conversions.AnyList());
                conversions.with(conversions.new StandardAttributeTypes.Conversions.AnyMap());
                conversions.with(conversions.new StandardAttributeTypes.Conversions.AnyDocumentObject());
            }

            @Override
            final ConversionSchema schema() {
                return ConversionSchemas.V2;
            }
        };


        abstract void include(StandardAttributeTypes.Conversions<Object> var1);

        abstract ConversionSchema schema();

        final StandardAttributeTypes.Conversions<Object> getConversions(final ConversionSchema.Dependencies depends, DynamoDBMapperModelFactory models) {
            StandardAttributeTypes.Conversions<Object> conversions = new StandardAttributeTypes.Conversions<Object>(StandardTypeConverters.factory(), models);
            conversions.with(String.class, S3Link.class, new StandardTypeConverters.DelegateConverter<String, S3Link>(StandardTypeConverters.converter(String.class, S3Link.class)){

                @Override
                public final S3Link unconvert(String o) {
                    return S3Link.fromJson(depends.get(S3ClientCache.class), o);
                }
            });
            this.include(conversions);
            return conversions;
        }

        static final Version of(DynamoDBMapperConfig config) {
            Version compatible = V1_5;
            for (Version version : Version.values()) {
                if (version.schema() == config.getConversionSchema()) {
                    return version;
                }
                if (!version.schema().toString().equals(config.getConversionSchema().toString())) continue;
                compatible = version;
            }
            return compatible;
        }
    }

    private static final class ItemConverterFactory {
        private final ItemConverter itemConverter;

        private ItemConverterFactory(DynamoDBMapperConfig config, ConversionSchema.Dependencies depends) {
            this.itemConverter = config.getConversionSchema().getConverter(depends);
        }

        final DynamoDBMapperFieldModel.DynamoDBAttributeType getDynamoDBAttributeType(StandardBeanProperties.Bean<?, Object> bean) {
            try {
                return this.itemConverter.getFieldModel(bean.getter()).getDynamoDBAttributeType();
            }
            catch (DynamoDBMappingException dynamoDBMappingException) {
                return DynamoDBMapperFieldModel.DynamoDBAttributeType.NULL;
            }
        }

        final DynamoDBTypeConverter<AttributeValue, Object> getConverter(final StandardBeanProperties.Bean<?, Object> bean) {
            return new DynamoDBTypeConverter<AttributeValue, Object>(){

                @Override
                public final AttributeValue convert(Object object) {
                    return ItemConverterFactory.this.itemConverter.convert(bean.getter(), object);
                }

                @Override
                public final Object unconvert(AttributeValue object) {
                    return ItemConverterFactory.this.itemConverter.unconvert(bean.getter(), bean.setter(), object);
                }
            };
        }
    }

    private static final class BeanModelFactory
    implements DynamoDBMapperModelFactory {
        private final ConcurrentMap<Class<?>, DynamoDBMapperTableModel<?>> cache = new ConcurrentHashMap();
        private final ItemConverterFactory itemConverter;
        private final StandardAttributeTypes.Conversions<Object> conversions;
        private final DynamoDBMapperConfig config;

        private BeanModelFactory(DynamoDBMapperConfig config, ConversionSchema.Dependencies depends) {
            this.conversions = Version.of(config).getConversions(depends, this);
            this.itemConverter = new ItemConverterFactory(config, depends);
            this.config = config;
        }

        @Override
        public <T> DynamoDBMapperTableModel<T> getTableModel(Class<T> targetType) {
            if (!this.cache.containsKey(targetType)) {
                this.cache.putIfAbsent(targetType, this.newTableModel(targetType));
            }
            return (DynamoDBMapperTableModel)this.cache.get(targetType);
        }

        private <T> DynamoDBMapperTableModel<T> newTableModel(Class<T> targetType) {
            DynamoDBMapperTableModel.Builder<T> table = new DynamoDBMapperTableModel.Builder<T>();
            table.with(StandardAnnotationMaps.of(targetType));
            if (table.tableName() != null) {
                table.withTableName(this.config.getTableNameResolver(true).getTableName(targetType, this.config));
            }
            for (StandardBeanProperties.Bean bean : StandardBeanProperties.of(targetType).values()) {
                table.with(this.newFieldModel(bean));
            }
            return table.build();
        }

        private <T> DynamoDBMapperFieldModel<T, Object> newFieldModel(StandardBeanProperties.Bean<T, Object> bean) {
            DynamoDBMapperFieldModel.Builder<T, Object> field = new DynamoDBMapperFieldModel.Builder<T, Object>();
            field.with(bean.id()).with(bean.reflect()).with(bean.annotations());
            if (bean.annotations().typeConverted() != null) {
                DynamoDBTypeConverter typeConverter = bean.annotations().typeConverter();
                StandardParameterTypes.ParamType<Object> type = StandardParameterTypes.ParamType.of(typeConverter);
                field.withScalarAttributeType(type.scalar().scalarAttributeType());
                field.with(StandardTypeConverters.join(this.conversions.getConverter(type), typeConverter));
            } else if (bean.annotations().nativeBoolean() != null) {
                field.with(this.conversions.nativeBoolean(bean.type()));
            } else {
                field.with(this.itemConverter.getDynamoDBAttributeType(bean));
                field.with(this.itemConverter.getConverter(bean));
            }
            return field.build();
        }
    }

    private static final class SchemaFactoryFactory
    implements DynamoDBMapperModelFactory.Factory {
        private final ConcurrentMap<ConversionSchema, DynamoDBMapperModelFactory> cache = new ConcurrentHashMap<ConversionSchema, DynamoDBMapperModelFactory>();
        private final ConversionSchema.Dependencies depends;

        private SchemaFactoryFactory(ConversionSchema.Dependencies depends) {
            this.depends = depends;
        }

        @Override
        public DynamoDBMapperModelFactory getModelFactory(DynamoDBMapperConfig config) {
            if (!this.cache.containsKey(config.getConversionSchema())) {
                this.cache.putIfAbsent(config.getConversionSchema(), new BeanModelFactory(config, this.depends));
            }
            return (DynamoDBMapperModelFactory)this.cache.get(config.getConversionSchema());
        }
    }
}

