/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class GetItemResult
implements Serializable,
Cloneable {
    private Map<String, AttributeValue> item;
    private ConsumedCapacity consumedCapacity;

    public Map<String, AttributeValue> getItem() {
        return this.item;
    }

    public void setItem(Map<String, AttributeValue> item) {
        this.item = item;
    }

    public GetItemResult withItem(Map<String, AttributeValue> item) {
        this.setItem(item);
        return this;
    }

    public GetItemResult addItemEntry(String key, AttributeValue value) {
        if (null == this.item) {
            this.item = new HashMap<String, AttributeValue>();
        }
        if (this.item.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.item.put(key, value);
        return this;
    }

    public GetItemResult clearItemEntries() {
        this.item = null;
        return this;
    }

    public void setConsumedCapacity(ConsumedCapacity consumedCapacity) {
        this.consumedCapacity = consumedCapacity;
    }

    public ConsumedCapacity getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public GetItemResult withConsumedCapacity(ConsumedCapacity consumedCapacity) {
        this.setConsumedCapacity(consumedCapacity);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getItem() != null) {
            sb.append("Item: " + this.getItem() + ",");
        }
        if (this.getConsumedCapacity() != null) {
            sb.append("ConsumedCapacity: " + this.getConsumedCapacity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetItemResult)) {
            return false;
        }
        GetItemResult other = (GetItemResult)obj;
        if (other.getItem() == null ^ this.getItem() == null) {
            return false;
        }
        if (other.getItem() != null && !other.getItem().equals(this.getItem())) {
            return false;
        }
        if (other.getConsumedCapacity() == null ^ this.getConsumedCapacity() == null) {
            return false;
        }
        return other.getConsumedCapacity() == null || other.getConsumedCapacity().equals(this.getConsumedCapacity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getItem() == null ? 0 : this.getItem().hashCode());
        hashCode = 31 * hashCode + (this.getConsumedCapacity() == null ? 0 : this.getConsumedCapacity().hashCode());
        return hashCode;
    }

    public GetItemResult clone() {
        try {
            return (GetItemResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

